/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.Comparator;

public class Pairs {
    public static IntPair intPair(int a, int b) {
        return new IntPair(a, b);
    }

    public static Comparator<IntPair> intPairComparator() {
        return new AscendingIntPairComparator();
    }

    public static Comparator<Number2ObjectPair> getAscendingnumber2ObjectPairComparator() {
        return new AscendingNumber2ObjectPairComparator();
    }

    public static Comparator<Number2ObjectPair> getDescendingnumber2ObjectPairComparator() {
        return new DescendingNumber2ObjectPairComparator();
    }

    public static class IntObjectComparator
    implements Comparator<IntObjectPair> {
        private final boolean _descending;

        public IntObjectComparator(boolean descending) {
            this._descending = descending;
        }

        @Override
        public int compare(IntObjectPair pair1, IntObjectPair pair2) {
            Object c2;
            Object c1 = pair1.getObjectValue();
            int cmpValue = c1.compareTo(c2 = pair2.getObjectValue());
            if (cmpValue == -1) {
                return this._descending ? 1 : -1;
            }
            if (cmpValue == 1) {
                return this._descending ? -1 : 1;
            }
            return 0;
        }
    }

    public static class IntObjectPair<T extends Comparable> {
        int _intValue;
        T _objectValue;

        public IntObjectPair(int intVal, T objectVal) {
            this._intValue = intVal;
            this._objectValue = objectVal;
        }

        public void setIntValue(int intValue) {
            this._intValue = intValue;
        }

        public int getIntValue() {
            return this._intValue;
        }

        public void setObjectValue(T objectValue) {
            this._objectValue = objectValue;
        }

        public T getObjectValue() {
            return this._objectValue;
        }
    }

    public static class IntDoubleComparator
    implements Comparator<IntDoublePair> {
        private final boolean _descending;

        public IntDoubleComparator(boolean descending) {
            this._descending = descending;
        }

        @Override
        public int compare(IntDoublePair o1, IntDoublePair o2) {
            double v2;
            double v1 = o1.getDoubleValue();
            if (v1 < (v2 = o2.getDoubleValue())) {
                return this._descending ? 1 : -1;
            }
            if (v1 > v2) {
                return this._descending ? -1 : 1;
            }
            return 0;
        }
    }

    public static class IntDoublePair {
        int _intValue;
        double _doubleValue;

        public IntDoublePair(int intVal, double doubleVal) {
            this._intValue = intVal;
            this._doubleValue = doubleVal;
        }

        public void setIntValue(int intVal) {
            this._intValue = intVal;
        }

        public int getIntValue() {
            return this._intValue;
        }

        public void setDoubleValue(double doubleVal) {
            this._doubleValue = doubleVal;
        }

        public double getDoubleValue() {
            return this._doubleValue;
        }
    }

    public static class DescendingNumber2ObjectPairComparator
    implements Comparator<Number2ObjectPair> {
        @Override
        public int compare(Number2ObjectPair o1, Number2ObjectPair o2) {
            return new Double(o2.a.doubleValue()).compareTo(new Double(o1.a.doubleValue()));
        }
    }

    public static class AscendingNumber2ObjectPairComparator
    implements Comparator<Number2ObjectPair> {
        @Override
        public int compare(Number2ObjectPair o1, Number2ObjectPair o2) {
            return new Double(o1.a.doubleValue()).compareTo(new Double(o2.a.doubleValue()));
        }
    }

    public static class Number2ObjectPair<T> {
        Number a;
        T b;

        public Number2ObjectPair(Number a, T b) {
            this.a = a;
            this.b = b;
        }

        public Number getA() {
            return this.a;
        }

        public T getB() {
            return this.b;
        }
    }

    public static class AscendingIntPairComparator
    implements Comparator<IntPair> {
        @Override
        public int compare(IntPair o1, IntPair o2) {
            return Integer.compare(o1.a, o2.a);
        }
    }

    public static class IntPair {
        int a;
        int b;

        public IntPair(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getLeft() {
            return this.a;
        }

        public int getRight() {
            return this.b;
        }

        public void setLeft(int a) {
            this.a = a;
        }

        public void setRight(int b) {
            this.b = b;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "]";
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntPair) {
                IntPair that = (IntPair)obj;
                return obj != null && this.a == that.a && this.b == that.b;
            }
            return false;
        }
    }
}

