/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import org.apache.pinot.common.utils.HLCSegmentName;

public abstract class SegmentName {
    public static final String SEPARATOR = "__";
    public static final String REALTIME_SUFFIX = "_REALTIME";
    public static final int REALTIME_SUFFIX_LENGTH = "_REALTIME".length();

    public static RealtimeSegmentType getSegmentType(String segmentName) {
        if (SegmentName.isHighLevelConsumerSegmentName(segmentName)) {
            HLCSegmentName segName = new HLCSegmentName(segmentName);
            if (segName.isOldStyleNaming()) {
                return RealtimeSegmentType.HLC_LONG;
            }
            return RealtimeSegmentType.HLC_SHORT;
        }
        if (SegmentName.isLowLevelConsumerSegmentName(segmentName)) {
            return RealtimeSegmentType.LLC;
        }
        return RealtimeSegmentType.UNSUPPORTED;
    }

    protected boolean isValidComponentName(String string) {
        return !string.contains(SEPARATOR);
    }

    public abstract String getTableName();

    public abstract String getSequenceNumberStr();

    public abstract int getSequenceNumber();

    public abstract String getSegmentName();

    public abstract RealtimeSegmentType getSegmentType();

    public String getGroupId() {
        throw new RuntimeException("No groupId in " + this.getSegmentName());
    }

    public int getPartitionId() {
        throw new RuntimeException("No partitionId in " + this.getSegmentName());
    }

    public String getPartitionRange() {
        throw new RuntimeException("No partitionRange in " + this.getSegmentName());
    }

    public static boolean isHighLevelConsumerSegmentName(String segmentName) {
        if (segmentName.endsWith(SEPARATOR) || segmentName.startsWith(SEPARATOR)) {
            return false;
        }
        String[] parts = segmentName.split(SEPARATOR);
        return parts.length == 3 || parts.length == 5;
    }

    public static boolean isLowLevelConsumerSegmentName(String segmentName) {
        if (segmentName.endsWith(SEPARATOR) || segmentName.startsWith(SEPARATOR)) {
            return false;
        }
        String[] parts = segmentName.split(SEPARATOR);
        return parts.length == 4;
    }

    public static enum RealtimeSegmentType {
        UNSUPPORTED,
        HLC_LONG,
        HLC_SHORT,
        LLC;

    }
}

