/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.pinot.$internal.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.pinot.$internal.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.pinot.$internal.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.pinot.$internal.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.pinot.$internal.org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.commons.io.IOUtils;
import org.apache.pinot.common.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarGzCompressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarGzCompressionUtils.class);
    public static final String TAR_GZ_FILE_EXTENSION = ".tar.gz";

    public static String createTarGzOfDirectory(String directoryPath, String tarGzPath) throws IOException {
        return TarGzCompressionUtils.createTarGzOfDirectory(directoryPath, tarGzPath, "");
    }

    public static String createTarGzOfDirectory(String directoryPath, String tarGzPath, String entryPrefix) throws IOException {
        if (!tarGzPath.endsWith(TAR_GZ_FILE_EXTENSION)) {
            tarGzPath = tarGzPath + TAR_GZ_FILE_EXTENSION;
        }
        try (FileOutputStream fOut = new FileOutputStream(new File(tarGzPath));
             BufferedOutputStream bOut = new BufferedOutputStream(fOut);
             GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream(bOut);
             TarArchiveOutputStream tOut = new TarArchiveOutputStream(gzOut);){
            tOut.setLongFileMode(2);
            TarGzCompressionUtils.addFileToTarGz(tOut, directoryPath, entryPrefix);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create tar.gz file for {} at path: {}", new Object[]{directoryPath, tarGzPath, e});
            Utils.rethrowException(e);
        }
        return tarGzPath;
    }

    public static String createTarGzOfDirectory(String directoryPath) throws IOException {
        String tarGzPath = directoryPath.substring(0);
        while (tarGzPath.endsWith("/")) {
            tarGzPath = tarGzPath.substring(0, tarGzPath.length() - 1);
        }
        tarGzPath = tarGzPath + TAR_GZ_FILE_EXTENSION;
        return TarGzCompressionUtils.createTarGzOfDirectory(directoryPath, tarGzPath);
    }

    private static void addFileToTarGz(TarArchiveOutputStream tOut, String path, String base) throws IOException {
        File f = new File(path);
        String entryName = base + f.getName();
        TarArchiveEntry tarEntry = new TarArchiveEntry(f, entryName);
        tOut.setLongFileMode(2);
        tOut.putArchiveEntry(tarEntry);
        if (f.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)tOut);
            tOut.closeArchiveEntry();
        } else {
            tOut.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    TarGzCompressionUtils.addFileToTarGz(tOut, child.getAbsolutePath(), entryName + "/");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> unTar(File inputFile, File outputDir) throws IOException, .ArchiveException {
        String outputDirectoryPath = outputDir.getCanonicalPath();
        LOGGER.debug("Untaring {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDirectoryPath);
        TarArchiveInputStream debInputStream = null;
        GzipCompressorInputStream is = null;
        LinkedList<File> untaredFiles = new LinkedList<File>();
        try {
            is = new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (!outputFile.getCanonicalPath().startsWith(outputDirectoryPath)) {
                    throw new IOException("Tar file must not be untarred outside of the target output directory!");
                }
                if (entry.isDirectory()) {
                    LOGGER.debug(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                    if (!outputFile.exists()) {
                        LOGGER.debug(String.format("Attempting to create output directory %s.", outputFile.getAbsolutePath()));
                        if (!outputFile.mkdirs()) {
                            throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                        }
                    } else {
                        LOGGER.error("The directory already there. Deleting - " + outputFile.getAbsolutePath());
                        FileUtils.deleteDirectory(outputFile);
                    }
                } else {
                    LOGGER.debug(String.format("Creating output file %s.", outputFile.getAbsolutePath()));
                    File directory = outputFile.getParentFile();
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    FileOutputStream outputFileStream = null;
                    try {
                        outputFileStream = new FileOutputStream(outputFile);
                        IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputFileStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(outputFileStream);
                }
                untaredFiles.add(outputFile);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(debInputStream);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly(debInputStream);
        IOUtils.closeQuietly(is);
        return untaredFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream unTarOneFile(InputStream tarGzInputStream, String filename) throws FileNotFoundException, IOException, .ArchiveException {
        ByteArrayInputStream byteArrayInputStream;
        TarArchiveInputStream debInputStream = null;
        GzipCompressorInputStream is = null;
        try {
            is = new GzipCompressorInputStream(tarGzInputStream);
            debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                if (!entry.getName().contains(filename)) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)debInputStream, (OutputStream)byteArrayOutputStream);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(debInputStream);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        {
            IOUtils.closeQuietly(debInputStream);
            IOUtils.closeQuietly(is);
            return byteArrayInputStream;
        }
        IOUtils.closeQuietly(debInputStream);
        IOUtils.closeQuietly(is);
        return null;
    }
}

