/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.pinot.$internal.com.google.common.base.Function;
import org.apache.pinot.common.config.TagNameUtils;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.retry.RetryPolicies;
import org.apache.pinot.common.utils.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixHelper {
    public static final int MAX_PARTITION_COUNT_IN_UNCOMPRESSED_IDEAL_STATE = 1000;
    private static final RetryPolicy DEFAULT_RETRY_POLICY = RetryPolicies.exponentialBackoffRetryPolicy(5, 1000L, 2.0);
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixHelper.class);
    private static final ZNRecordSerializer ZN_RECORD_SERIALIZER = new ZNRecordSerializer();
    private static final String ONLINE = "ONLINE";
    private static final String OFFLINE = "OFFLINE";
    public static final String BROKER_RESOURCE = "brokerResource";

    public static IdealState cloneIdealState(IdealState idealState) {
        return new IdealState((ZNRecord)ZN_RECORD_SERIALIZER.deserialize(ZN_RECORD_SERIALIZER.serialize((Object)idealState.getRecord())));
    }

    public static void updateIdealState(final HelixManager helixManager, final String resourceName, final Function<IdealState, IdealState> updater, RetryPolicy policy, final boolean noChangeOk) {
        try {
            policy.attempt(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    IdealState updatedIdealState;
                    HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
                    PropertyKey idealStateKey = dataAccessor.keyBuilder().idealStates(resourceName);
                    IdealState idealState = (IdealState)dataAccessor.getProperty(idealStateKey);
                    IdealState idealStateCopy = HelixHelper.cloneIdealState(idealState);
                    try {
                        updatedIdealState = (IdealState)updater.apply(idealStateCopy);
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while updating ideal state for resource: {}", (Object)resourceName, (Object)e);
                        return false;
                    }
                    if (!EqualityUtils.isEqual(idealState, updatedIdealState) && updatedIdealState != null) {
                        if (1000 < updatedIdealState.getPartitionSet().size()) {
                            updatedIdealState.getRecord().setBooleanField("enableCompression", true);
                        }
                        try {
                            if (dataAccessor.getBaseDataAccessor().set(idealStateKey.getPath(), (Object)updatedIdealState.getRecord(), idealState.getRecord().getVersion(), AccessOption.PERSISTENT)) {
                                return true;
                            }
                            LOGGER.warn("Failed to update ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (ZkBadVersionException e) {
                            LOGGER.warn("Version changed while updating ideal state for resource: {}", (Object)resourceName);
                            return false;
                        }
                        catch (Exception e) {
                            boolean idealStateIsCompressed = updatedIdealState.getRecord().getBooleanField("enableCompression", false);
                            LOGGER.warn("Caught exception while updating ideal state for resource: {} (compressed={})", new Object[]{resourceName, idealStateIsCompressed, e});
                            return false;
                        }
                    }
                    if (noChangeOk) {
                        LOGGER.info("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    } else {
                        LOGGER.warn("Idempotent or null ideal state update for resource {}, skipping update.", (Object)resourceName);
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while updating ideal state for resource: " + resourceName, e);
        }
    }

    public static void updateIdealState(HelixManager helixManager, String resourceName, Function<IdealState, IdealState> updater, RetryPolicy policy) {
        HelixHelper.updateIdealState(helixManager, resourceName, updater, policy, false);
    }

    public static List<String> getAllInstances(HelixAdmin helixAdmin, String clusterName) {
        return helixAdmin.getInstancesInCluster(clusterName);
    }

    public static Set<String> getAllInstancesForResource(IdealState idealState) {
        HashSet<String> instances = new HashSet<String>();
        for (String partition : idealState.getPartitionSet()) {
            for (String instance : idealState.getInstanceSet(partition)) {
                instances.add(instance);
            }
        }
        return instances;
    }

    public static void setInstanceState(String instanceName, String clusterName, HelixAdmin admin, boolean enable) {
        admin.enableInstance(clusterName, instanceName, enable);
    }

    public static void setStateForInstanceList(List<String> instances, String clusterName, HelixAdmin admin, boolean enable) {
        for (String instance : instances) {
            HelixHelper.setInstanceState(instance, clusterName, admin, enable);
        }
    }

    public static void setStateForInstanceSet(Set<String> instances, String clusterName, HelixAdmin admin, boolean enable) {
        for (String instanceName : instances) {
            HelixHelper.setInstanceState(instanceName, clusterName, admin, enable);
        }
    }

    public static Map<String, String> getInstanceConfigsMapFor(String instanceName, String clusterName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getInstanceScopefor(clusterName, instanceName);
        List keys = admin.getConfigKeys(scope);
        return admin.getConfig(scope, keys);
    }

    public static HelixConfigScope getInstanceScopefor(String clusterName, String instanceName) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, new String[]{clusterName}).forParticipant(instanceName).build();
    }

    public static HelixConfigScope getResourceScopeFor(String clusterName, String resourceName) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE, new String[]{clusterName}).forResource(resourceName).build();
    }

    public static Map<String, String> getResourceConfigsFor(String clusterName, String resourceName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        List keys = admin.getConfigKeys(scope);
        return admin.getConfig(scope, keys);
    }

    public static void updateResourceConfigsFor(Map<String, String> newConfigs, String resourceName, String clusterName, HelixAdmin admin) {
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        admin.setConfig(scope, newConfigs);
    }

    public static void deleteResourcePropertyFromHelix(HelixAdmin admin, String clusterName, String resourceName, String configKey) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(configKey);
        HelixConfigScope scope = HelixHelper.getResourceScopeFor(clusterName, resourceName);
        admin.removeConfig(scope, keys);
    }

    public static IdealState getTableIdealState(HelixManager manager, String resourceName) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder builder = accessor.keyBuilder();
        return (IdealState)accessor.getProperty(builder.idealStates(resourceName));
    }

    public static ExternalView getExternalViewForResource(HelixAdmin admin, String clusterName, String resourceName) {
        return admin.getResourceExternalView(clusterName, resourceName);
    }

    public static Map<String, String> getBrokerResourceConfig(HelixAdmin admin, String clusterName) {
        return HelixHelper.getResourceConfigsFor(clusterName, BROKER_RESOURCE, admin);
    }

    public static void updateBrokerConfig(Map<String, String> brokerResourceConfig, HelixAdmin admin, String clusterName) {
        HelixHelper.updateResourceConfigsFor(brokerResourceConfig, BROKER_RESOURCE, clusterName, admin);
    }

    public static IdealState getBrokerIdealStates(HelixAdmin admin, String clusterName) {
        return admin.getResourceIdealState(clusterName, BROKER_RESOURCE);
    }

    public static void removeResourceFromBrokerIdealState(HelixManager helixManager, final String resourceTag) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            @Override
            public IdealState apply(IdealState idealState) {
                if (idealState.getPartitionSet().contains(resourceTag)) {
                    idealState.getPartitionSet().remove(resourceTag);
                    return idealState;
                }
                return null;
            }
        };
        LOGGER.info("Trying to remove resource {} from idealstate", (Object)resourceTag);
        HelixHelper.updateIdealState(helixManager, BROKER_RESOURCE, updater, DEFAULT_RETRY_POLICY);
    }

    public static Set<String> getOnlineInstanceFromExternalView(ExternalView resourceExternalView) {
        HashSet<String> instanceSet = new HashSet<String>();
        if (resourceExternalView != null) {
            for (String partition : resourceExternalView.getPartitionSet()) {
                Map stateMap = resourceExternalView.getStateMap(partition);
                for (String instance : stateMap.keySet()) {
                    if (!((String)stateMap.get(instance)).equalsIgnoreCase(ONLINE)) continue;
                    instanceSet.add(instance);
                }
            }
        }
        return instanceSet;
    }

    public static Set<String> getOfflineInstanceFromExternalView(ExternalView resourceExternalView) {
        HashSet<String> instanceSet = new HashSet<String>();
        for (String partition : resourceExternalView.getPartitionSet()) {
            Map stateMap = resourceExternalView.getStateMap(partition);
            for (String instance : stateMap.keySet()) {
                if (!((String)stateMap.get(instance)).equalsIgnoreCase(OFFLINE)) continue;
                instanceSet.add(instance);
            }
        }
        return instanceSet;
    }

    public static void removeSegmentFromIdealState(HelixManager helixManager, String tableName, final String segmentName) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            @Override
            public IdealState apply(IdealState idealState) {
                if (idealState == null) {
                    return idealState;
                }
                Set partitionSet = idealState.getPartitionSet();
                if (partitionSet != null) {
                    partitionSet.remove(segmentName);
                }
                return idealState;
            }
        };
        HelixHelper.updateIdealState(helixManager, tableName, updater, DEFAULT_RETRY_POLICY);
    }

    public static void removeSegmentsFromIdealState(HelixManager helixManager, String tableName, final List<String> segments) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            @Override
            @Nullable
            public IdealState apply(@Nullable IdealState idealState) {
                if (idealState == null) {
                    return idealState;
                }
                Set partitionSet = idealState.getPartitionSet();
                if (partitionSet != null) {
                    partitionSet.removeAll(segments);
                }
                return idealState;
            }
        };
        HelixHelper.updateIdealState(helixManager, tableName, updater, DEFAULT_RETRY_POLICY);
    }

    public static void addSegmentToIdealState(HelixManager helixManager, final String tableNameWithType, final String segmentName, final List<String> assignedInstances) {
        Function<IdealState, IdealState> updater = new Function<IdealState, IdealState>(){

            @Override
            public IdealState apply(IdealState idealState) {
                Set partitions = idealState.getPartitionSet();
                if (partitions.contains(segmentName)) {
                    LOGGER.warn("Segment already exists in the ideal state for segment: {} of table: {}, do not update", (Object)segmentName, (Object)tableNameWithType);
                } else if (assignedInstances.isEmpty()) {
                    LOGGER.warn("No instance assigned for segment: {} of table: {}", (Object)segmentName, (Object)tableNameWithType);
                } else {
                    int numPartitions = partitions.size() + 1;
                    for (String instance : assignedInstances) {
                        idealState.setPartitionState(segmentName, instance, HelixHelper.ONLINE);
                    }
                    idealState.setNumPartitions(numPartitions);
                }
                return idealState;
            }
        };
        HelixHelper.updateIdealState(helixManager, tableNameWithType, updater, DEFAULT_RETRY_POLICY);
    }

    public static List<InstanceConfig> getInstanceConfigs(HelixManager helixManager) {
        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
        return helixDataAccessor.getChildValues(helixDataAccessor.keyBuilder().instanceConfigs());
    }

    public static List<String> getInstancesWithTag(HelixManager helixManager, String tag) {
        return HelixHelper.getInstancesWithTag(HelixHelper.getInstanceConfigs(helixManager), tag);
    }

    public static List<String> getInstancesWithTag(List<InstanceConfig> instanceConfigs, String tag) {
        ArrayList<String> instancesWithTag = new ArrayList<String>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.containsTag(tag)) continue;
            instancesWithTag.add(instanceConfig.getInstanceName());
        }
        return instancesWithTag;
    }

    public static List<String> getEnabledInstancesWithTag(HelixManager helixManager, String tag) {
        return HelixHelper.getEnabledInstancesWithTag(HelixHelper.getInstanceConfigs(helixManager), tag);
    }

    public static List<String> getEnabledInstancesWithTag(List<InstanceConfig> instanceConfigs, String tag) {
        ArrayList<String> enabledInstancesWithTag = new ArrayList<String>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.getInstanceEnabled() || !instanceConfig.containsTag(tag)) continue;
            enabledInstancesWithTag.add(instanceConfig.getInstanceName());
        }
        return enabledInstancesWithTag;
    }

    public static Set<String> getServerInstancesForTenant(List<InstanceConfig> instanceConfigs, String tenant) {
        HashSet<String> serverInstances = new HashSet<String>();
        serverInstances.addAll(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getOfflineTagForTenant(tenant)));
        serverInstances.addAll(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getRealtimeTagForTenant(tenant)));
        return serverInstances;
    }

    public static Set<String> getBrokerInstancesForTenant(List<InstanceConfig> instanceConfigs, String tenant) {
        return new HashSet<String>(HelixHelper.getInstancesWithTag(instanceConfigs, TagNameUtils.getBrokerTagForTenant(tenant)));
    }
}

