/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.pinot.$internal.org.apache.commons.lang.mutable.MutableInt;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.FilterQuery;
import org.apache.pinot.common.request.FilterQueryMap;
import org.apache.pinot.common.request.HavingFilterQuery;
import org.apache.pinot.common.request.HavingFilterQueryMap;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class RequestUtils {
    private RequestUtils() {
    }

    public static void generateFilterFromTree(FilterQueryTree filterQueryTree, BrokerRequest request) {
        HashMap<Integer, FilterQuery> filterQueryMap = new HashMap<Integer, FilterQuery>();
        MutableInt currentId = new MutableInt(0);
        FilterQuery root = RequestUtils.traverseFilterQueryAndPopulateMap(filterQueryTree, filterQueryMap, currentId);
        filterQueryMap.put(root.getId(), root);
        request.setFilterQuery(root);
        FilterQueryMap mp = new FilterQueryMap();
        mp.setFilterQueryMap(filterQueryMap);
        request.setFilterSubQueryMap(mp);
    }

    public static void generateFilterFromTree(HavingQueryTree filterQueryTree, BrokerRequest request) {
        HashMap<Integer, HavingFilterQuery> filterQueryMap = new HashMap<Integer, HavingFilterQuery>();
        MutableInt currentId = new MutableInt(0);
        HavingFilterQuery root = RequestUtils.traverseHavingFilterQueryAndPopulateMap(filterQueryTree, filterQueryMap, currentId);
        filterQueryMap.put(root.getId(), root);
        request.setHavingFilterQuery(root);
        HavingFilterQueryMap mp = new HavingFilterQueryMap();
        mp.setFilterQueryMap(filterQueryMap);
        request.setHavingFilterSubQueryMap(mp);
    }

    private static FilterQuery traverseFilterQueryAndPopulateMap(FilterQueryTree tree, Map<Integer, FilterQuery> filterQueryMap, MutableInt currentId) {
        int currentNodeId = currentId.intValue();
        currentId.increment();
        ArrayList<Integer> f = new ArrayList<Integer>();
        if (null != tree.getChildren()) {
            for (FilterQueryTree c : tree.getChildren()) {
                int childNodeId = currentId.intValue();
                currentId.increment();
                f.add(childNodeId);
                FilterQuery q = RequestUtils.traverseFilterQueryAndPopulateMap(c, filterQueryMap, currentId);
                filterQueryMap.put(childNodeId, q);
            }
        }
        FilterQuery query = new FilterQuery();
        query.setColumn(tree.getColumn());
        query.setId(currentNodeId);
        query.setNestedFilterQueryIds(f);
        query.setOperator(tree.getOperator());
        query.setValue(tree.getValue());
        return query;
    }

    private static HavingFilterQuery traverseHavingFilterQueryAndPopulateMap(HavingQueryTree tree, Map<Integer, HavingFilterQuery> filterQueryMap, MutableInt currentId) {
        int currentNodeId = currentId.intValue();
        currentId.increment();
        ArrayList<Integer> filterIds = new ArrayList<Integer>();
        if (null != tree.getChildren()) {
            for (HavingQueryTree child : tree.getChildren()) {
                int childNodeId = currentId.intValue();
                currentId.increment();
                filterIds.add(childNodeId);
                HavingFilterQuery filterQuery = RequestUtils.traverseHavingFilterQueryAndPopulateMap(child, filterQueryMap, currentId);
                filterQueryMap.put(childNodeId, filterQuery);
            }
        }
        HavingFilterQuery havingFilterQuery = new HavingFilterQuery();
        havingFilterQuery.setAggregationInfo(tree.getAggregationInfo());
        havingFilterQuery.setId(currentNodeId);
        havingFilterQuery.setNestedFilterQueryIds(filterIds);
        havingFilterQuery.setOperator(tree.getOperator());
        havingFilterQuery.setValue(tree.getValue());
        return havingFilterQuery;
    }

    public static FilterQueryTree generateFilterQueryTree(BrokerRequest request) {
        FilterQueryTree root = null;
        FilterQuery q = request.getFilterQuery();
        if (null != q && null != request.getFilterSubQueryMap()) {
            root = RequestUtils.buildFilterQuery(q.getId(), request.getFilterSubQueryMap().getFilterQueryMap());
        }
        return root;
    }

    public static FilterQueryTree buildFilterQuery(Integer id, Map<Integer, FilterQuery> queryMap) {
        FilterQuery q = queryMap.get(id);
        List<Integer> children = q.getNestedFilterQueryIds();
        ArrayList<FilterQueryTree> c = null;
        if (null != children && !children.isEmpty()) {
            c = new ArrayList<FilterQueryTree>();
            for (Integer i : children) {
                FilterQueryTree t = RequestUtils.buildFilterQuery(i, queryMap);
                c.add(t);
            }
        }
        return new FilterQueryTree(q.getColumn(), q.getValue(), q.getOperator(), c);
    }

    public static Set<String> extractFilterColumns(FilterQueryTree root) {
        HashSet<String> filterColumns = new HashSet<String>();
        if (root.getChildren() == null) {
            filterColumns.add(root.getColumn());
        } else {
            Stack<FilterQueryTree> stack = new Stack<FilterQueryTree>();
            stack.add(root);
            while (!stack.empty()) {
                FilterQueryTree node = (FilterQueryTree)stack.pop();
                for (FilterQueryTree child : node.getChildren()) {
                    if (child.getChildren() == null) {
                        filterColumns.add(child.getColumn());
                        continue;
                    }
                    stack.push(child);
                }
            }
        }
        return filterColumns;
    }

    public static Set<String> extractColumnsFromExpressions(Set<TransformExpressionTree> expressions) {
        HashSet<String> expressionColumns = new HashSet<String>();
        for (TransformExpressionTree expression : expressions) {
            expression.getColumns(expressionColumns);
        }
        return expressionColumns;
    }

    public static Set<String> extractSelectionColumns(Selection selection) {
        HashSet<String> selectionColumns = new HashSet<String>();
        for (String selectionColumn : selection.getSelectionColumns()) {
            if (selectionColumn.equals("*")) continue;
            selectionColumns.add(selectionColumn);
        }
        if (selection.getSelectionSortSequence() != null) {
            for (SelectionSort selectionSort : selection.getSelectionSortSequence()) {
                selectionColumns.add(selectionSort.getColumn());
            }
        }
        return selectionColumns;
    }
}

