/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.pinot.common.utils.retry.BaseRetryPolicy;

public class ExponentialBackoffRetryPolicy
extends BaseRetryPolicy {
    private final ThreadLocalRandom _random = ThreadLocalRandom.current();
    private final long _initialDelayMs;
    private final double _delayScaleFactor;

    public ExponentialBackoffRetryPolicy(int maxNumAttempts, long initialDelayMs, double delayScaleFactor) {
        super(maxNumAttempts);
        this._initialDelayMs = initialDelayMs;
        this._delayScaleFactor = delayScaleFactor;
    }

    @Override
    protected long getDelayMs(int currentAttempt) {
        double minDelayMs = (double)this._initialDelayMs * Math.pow(this._delayScaleFactor, currentAttempt);
        double maxDelayMs = minDelayMs * this._delayScaleFactor;
        return this._random.nextLong((long)minDelayMs, (long)maxDelayMs);
    }
}

