/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.time;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class TimeUtils {
    private static final Map<String, TimeUnit> TIME_UNIT_MAP = new HashMap<String, TimeUnit>();
    private static final long VALID_MIN_TIME_MILLIS = new DateTime(1971, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long VALID_MAX_TIME_MILLIS = new DateTime(2071, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
    private static final PeriodFormatter PERIOD_FORMATTER;

    public static long toMillis(String timeUnitString, String timeValue) {
        TimeUnit timeUnit = TimeUtils.timeUnitFromString(timeUnitString);
        return timeUnit == null ? Long.MIN_VALUE : timeUnit.toMillis(Long.parseLong(timeValue));
    }

    public static TimeUnit timeUnitFromString(String timeUnitString) {
        if (timeUnitString == null) {
            return null;
        }
        return TIME_UNIT_MAP.get(timeUnitString.toUpperCase());
    }

    public static boolean timeValueInValidRange(long timeValueInMillis) {
        return VALID_MIN_TIME_MILLIS <= timeValueInMillis && timeValueInMillis <= VALID_MAX_TIME_MILLIS;
    }

    public static long getValidMinTimeMillis() {
        return VALID_MIN_TIME_MILLIS;
    }

    public static long getValidMaxTimeMillis() {
        return VALID_MAX_TIME_MILLIS;
    }

    public static Long convertPeriodToMillis(String timeStr) {
        Long millis = 0L;
        if (timeStr != null) {
            try {
                Period p = PERIOD_FORMATTER.parsePeriod(timeStr);
                millis = p.toStandardDuration().getStandardSeconds() * 1000L;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid time spec '" + timeStr + "' (Valid examples: '3h', '4h30m')", e);
            }
        }
        return millis;
    }

    public static String convertMillisToPeriod(Long millis) {
        String periodStr = null;
        if (millis != null) {
            Period p = new Period((Object)new Duration((Object)millis));
            periodStr = PERIOD_FORMATTER.print((ReadablePeriod)p);
        }
        return periodStr;
    }

    static {
        for (TimeUnit timeUnit : TimeUnit.values()) {
            TIME_UNIT_MAP.put(timeUnit.name(), timeUnit);
        }
        PERIOD_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();
    }
}

