/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.webhdfs;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.$internal.org.apache.commons.httpclient.HttpClient;
import org.apache.pinot.$internal.org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.pinot.$internal.org.apache.commons.httpclient.methods.PutMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHdfsV1Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebHdfsV1Client.class);
    private static final String LOCATION = "Location";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final boolean DEFAULT_OVERWRITE = true;
    private static final int DEFAULT_PERMISSION = 755;
    private static final String WEB_HDFS_UPLOAD_PATH_TEMPLATE = "%s://%s:%s/webhdfs/v1%s?op=CREATE&overwrite=%s&permission=%s";
    private static final String WEB_HDFS_DOWNLOAD_PATH_TEMPLATE = "%s://%s:%s/webhdfs/v1%s?op=OPEN";
    private final String _protocol;
    private final String _host;
    private final int _port;
    private final boolean _overwrite;
    private final int _permission;
    private final HttpClient _httpClient;

    public WebHdfsV1Client(String host, int port) {
        this(host, port, DEFAULT_PROTOCOL, true, 755);
    }

    public WebHdfsV1Client(String host, int port, String protocol, boolean overwrite, int permission) {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._overwrite = overwrite;
        this._permission = permission;
        this._httpClient = new HttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean uploadSegment(String webHdfsPath, String localFilePath) {
        String firstPutReqString = String.format(WEB_HDFS_UPLOAD_PATH_TEMPLATE, this._protocol, this._host, this._port, webHdfsPath, this._overwrite, this._permission);
        PutMethod firstPutReq = new PutMethod(firstPutReqString);
        try {
            LOGGER.info("Trying to send request: {}.", (Object)firstPutReqString);
            int firstResponseCode = this._httpClient.executeMethod(firstPutReq);
            if (firstResponseCode != 307) {
                LOGGER.error(String.format("Failed to execute the first PUT request to upload segment to webhdfs: %s. Expected response code 307, but get %s. Response body: %s", firstPutReqString, firstResponseCode, firstPutReq.getResponseBodyAsString()));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to execute the first request to upload segment to webhdfs: %s.", firstPutReqString), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            firstPutReq.releaseConnection();
        }
        String redirectedReqString = firstPutReq.getResponseHeader(LOCATION).getValue();
        PutMethod redirectedReq = new PutMethod(redirectedReqString);
        File localFile = new File(localFilePath);
        FileRequestEntity requestEntity = new FileRequestEntity(localFile, "application/binary");
        redirectedReq.setRequestEntity(requestEntity);
        try {
            LOGGER.info("Trying to send request: {}.", (Object)redirectedReqString);
            int redirectedResponseCode = this._httpClient.executeMethod(redirectedReq);
            if (redirectedResponseCode != 201) {
                LOGGER.error(String.format("Failed to execute the redirected PUT request to upload segment to webhdfs: %s. Expected response code 201, but get %s. Response: %s", redirectedReqString, redirectedResponseCode, redirectedReq.getResponseBodyAsString()));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to execute the redirected request to upload segment to webhdfs: %s.", redirectedReqString), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            redirectedReq.releaseConnection();
        }
    }

    public String getDownloadUriPath(String webHdfsPath) {
        return String.format(WEB_HDFS_DOWNLOAD_PATH_TEMPLATE, this._protocol, this._host, this._port, webHdfsPath);
    }
}

