/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.filesystem.PinotFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPinotFS
extends PinotFS {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPinotFS.class);
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public boolean mkdir(URI uri) throws IOException {
        FileUtils.forceMkdir(new File(this.decodeURI(uri.getRawPath())));
        return true;
    }

    @Override
    public boolean delete(URI segmentUri, boolean forceDelete) throws IOException {
        File file = new File(this.decodeURI(segmentUri.getRawPath()));
        if (file.isDirectory()) {
            if (this.listFiles(segmentUri, false).length > 0 && !forceDelete) {
                return false;
            }
        } else {
            return FileUtils.deleteQuietly(file);
        }
        FileUtils.deleteDirectory(file);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean move(URI srcUri, URI dstUri, boolean overwrite) throws IOException {
        File srcFile = new File(this.decodeURI(srcUri.getRawPath()));
        File dstFile = new File(this.decodeURI(dstUri.getRawPath()));
        if (dstFile.exists()) {
            if (!overwrite) return false;
            FileUtils.deleteQuietly(dstFile);
        } else {
            FileUtils.forceMkdir(dstFile.getParentFile());
        }
        Files.move(srcFile.toPath(), dstFile.toPath(), new CopyOption[0]);
        return true;
    }

    @Override
    public boolean copy(URI srcUri, URI dstUri) throws IOException {
        File srcFile = new File(this.decodeURI(srcUri.getRawPath()));
        File dstFile = new File(this.decodeURI(dstUri.getRawPath()));
        if (dstFile.exists()) {
            FileUtils.deleteQuietly(dstFile);
        }
        if (srcFile.isDirectory()) {
            FileUtils.copyDirectory(srcFile, dstFile);
        } else {
            FileUtils.copyFile(srcFile, dstFile);
        }
        return true;
    }

    @Override
    public boolean exists(URI fileUri) throws IOException {
        File file = new File(this.decodeURI(fileUri.getRawPath()));
        return file.exists();
    }

    @Override
    public long length(URI fileUri) throws IOException {
        File file = new File(this.decodeURI(fileUri.getRawPath()));
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File is directory");
        }
        return FileUtils.sizeOf(file);
    }

    @Override
    public String[] listFiles(URI fileUri, boolean recursive) throws IOException {
        File file = new File(this.decodeURI(fileUri.getRawPath()));
        if (!recursive) {
            return (String[])Arrays.stream(file.list()).map(s -> new File(file, (String)s)).map(File::getAbsolutePath).toArray(String[]::new);
        }
        return (String[])Files.walk(Paths.get(fileUri), new FileVisitOption[0]).filter(s -> !s.equals(file.toPath())).map(Path::toString).toArray(String[]::new);
    }

    @Override
    public void copyToLocalFile(URI srcUri, File dstFile) throws Exception {
        this.copy(srcUri, new URI(this.encodeURI(dstFile.getAbsolutePath())));
    }

    @Override
    public void copyFromLocalFile(File srcFile, URI dstUri) throws Exception {
        this.copy(new URI(this.encodeURI(srcFile.getAbsolutePath())), dstUri);
    }

    @Override
    public boolean isDirectory(URI uri) {
        File file = new File(this.decodeURI(uri.getRawPath()));
        return file.isDirectory();
    }

    @Override
    public long lastModified(URI uri) {
        File file = new File(this.decodeURI(uri.getRawPath()));
        return file.lastModified();
    }

    @Override
    public boolean touch(URI uri) throws IOException {
        File file = new File(this.decodeURI(uri.getRawPath()));
        if (!this.exists(uri)) {
            return file.createNewFile();
        }
        return file.setLastModified(System.currentTimeMillis());
    }

    private String encodeURI(String uri) {
        String encodedStr;
        try {
            encodedStr = URLEncoder.encode(uri, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Could not encode uri {}", (Object)uri);
            throw new RuntimeException(e);
        }
        return encodedStr;
    }

    private String decodeURI(String uri) {
        String decodedStr;
        try {
            decodedStr = URLDecoder.decode(uri, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Could not decode uri {}", (Object)uri);
            throw new RuntimeException(e);
        }
        return decodedStr;
    }
}

