/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.filesystem;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.filesystem.LocalPinotFS;
import org.apache.pinot.filesystem.PinotFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotFSFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotFSFactory.class);
    private static final String DEFAULT_FS_SCHEME = "file";
    private static final String CLASS = "class";
    private static Map<String, PinotFS> _fileSystemMap = new HashMap<String, PinotFS>();

    private PinotFSFactory() {
    }

    public static void init(Configuration fsConfig) {
        Iterator keys = fsConfig.subset(CLASS).getKeys();
        if (!keys.hasNext()) {
            LOGGER.info("Did not find any fs classes in the configuration");
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String fsClassName = (String)fsConfig.getProperty("class." + key);
            LOGGER.info("Got scheme {}, classname {}, starting to initialize", (Object)key, (Object)fsClassName);
            try {
                PinotFS pinotFS = (PinotFS)Class.forName(fsClassName).newInstance();
                pinotFS.init(fsConfig.subset(key));
                LOGGER.info("Initializing PinotFS for scheme {}, classname {}", (Object)key, (Object)fsClassName);
                _fileSystemMap.put(key, pinotFS);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("Could not instantiate file system for class {}", (Object)fsClassName, (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (!_fileSystemMap.containsKey(DEFAULT_FS_SCHEME)) {
            LOGGER.info("LocalPinotFS not configured, adding as default");
            _fileSystemMap.put(DEFAULT_FS_SCHEME, new LocalPinotFS());
        }
    }

    public static PinotFS create(String scheme) {
        PinotFS pinotFS = _fileSystemMap.get(scheme);
        if (pinotFS == null) {
            throw new RuntimeException("Pinot file system not configured for scheme: " + scheme);
        }
        return pinotFS;
    }

    public static void shutdown() throws IOException {
        for (PinotFS pinotFS : _fileSystemMap.values()) {
            pinotFS.close();
        }
    }
}

