/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.realtime;

import java.io.File;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.utils.Pair;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.ClientSSLContextGenerator;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.server.realtime.ControllerLeaderLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSegmentCompletionProtocolHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ServerSegmentCompletionProtocolHandler.class);
    private static final int SEGMENT_UPLOAD_REQUEST_TIMEOUT_MS = 30000;
    private static final int OTHER_REQUESTS_TIMEOUT = 10000;
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    private static final String CONFIG_OF_CONTROLLER_HTTPS_ENABLED = "enabled";
    private static final String CONFIG_OF_CONTROLLER_HTTPS_PORT = "controller.port";
    private static SSLContext _sslContext;
    private static Integer _controllerHttpsPort;
    private final FileUploadDownloadClient _fileUploadDownloadClient = new FileUploadDownloadClient(_sslContext);
    private final ServerMetrics _serverMetrics;

    public static void init(Configuration uploaderConfig) {
        Configuration httpsConfig = uploaderConfig.subset(HTTPS_PROTOCOL);
        if (httpsConfig.getBoolean(CONFIG_OF_CONTROLLER_HTTPS_ENABLED, false)) {
            _sslContext = new ClientSSLContextGenerator(httpsConfig.subset("ssl")).generate();
            _controllerHttpsPort = httpsConfig.getInt(CONFIG_OF_CONTROLLER_HTTPS_PORT);
        }
    }

    public ServerSegmentCompletionProtocolHandler(ServerMetrics serverMetrics) {
        this._serverMetrics = serverMetrics;
    }

    public SegmentCompletionProtocol.Response segmentCommitStart(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentCommitStartRequest request = new SegmentCompletionProtocol.SegmentCommitStartRequest(params);
        String url = this.createSegmentCompletionUrl(request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentCommitUpload(SegmentCompletionProtocol.Request.Params params, File segmentTarFile, String controllerVipUrl) {
        String hostPort;
        String protocol;
        SegmentCompletionProtocol.SegmentCommitUploadRequest request = new SegmentCompletionProtocol.SegmentCommitUploadRequest(params);
        try {
            URI uri = URI.create(controllerVipUrl);
            protocol = uri.getScheme();
            hostPort = uri.getAuthority();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not make URI", e);
        }
        String url = request.getUrl(hostPort, protocol);
        return this.uploadSegment(url, params.getSegmentName(), segmentTarFile);
    }

    public SegmentCompletionProtocol.Response segmentCommitEnd(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentCommitEndRequest request = new SegmentCompletionProtocol.SegmentCommitEndRequest(params);
        String url = this.createSegmentCompletionUrl(request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentCommit(SegmentCompletionProtocol.Request.Params params, File segmentTarFile) {
        SegmentCompletionProtocol.SegmentCommitRequest request = new SegmentCompletionProtocol.SegmentCommitRequest(params);
        String url = this.createSegmentCompletionUrl(request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.uploadSegment(url, params.getSegmentName(), segmentTarFile);
    }

    public SegmentCompletionProtocol.Response extendBuildTime(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.ExtendBuildTimeRequest request = new SegmentCompletionProtocol.ExtendBuildTimeRequest(params);
        String url = this.createSegmentCompletionUrl(request);
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentConsumed(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentConsumedRequest request = new SegmentCompletionProtocol.SegmentConsumedRequest(params);
        String url = this.createSegmentCompletionUrl(request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentStoppedConsuming(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentStoppedConsuming request = new SegmentCompletionProtocol.SegmentStoppedConsuming(params);
        String url = this.createSegmentCompletionUrl(request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    private String createSegmentCompletionUrl(SegmentCompletionProtocol.Request request) {
        ControllerLeaderLocator leaderLocator = ControllerLeaderLocator.getInstance();
        Pair<String, Integer> leaderHostPort = leaderLocator.getControllerLeader();
        if (leaderHostPort == null) {
            LOGGER.warn("No leader found while trying to send {}", (Object)request.toString());
            return null;
        }
        String protocol = HTTP_PROTOCOL;
        if (_controllerHttpsPort != null) {
            leaderHostPort.setSecond(_controllerHttpsPort);
            protocol = HTTPS_PROTOCOL;
        }
        return request.getUrl(leaderHostPort.getFirst() + ":" + leaderHostPort.getSecond(), protocol);
    }

    private SegmentCompletionProtocol.Response sendRequest(String url) {
        SegmentCompletionProtocol.Response response;
        try {
            String responseStr = this._fileUploadDownloadClient.sendSegmentCompletionProtocolRequest(new URI(url), 10000).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString(responseStr);
            LOGGER.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)url);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            LOGGER.error("Could not send request {}", (Object)url, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        this.raiseSegmentCompletionProtocolResponseMetric(response);
        return response;
    }

    private SegmentCompletionProtocol.Response uploadSegment(String url, String segmentName, File segmentTarFile) {
        SegmentCompletionProtocol.Response response;
        try {
            String responseStr = this._fileUploadDownloadClient.uploadSegment(new URI(url), segmentName, segmentTarFile, null, null, 30000).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString(responseStr);
            LOGGER.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)url);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            LOGGER.error("Could not send request {}", (Object)url, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        this.raiseSegmentCompletionProtocolResponseMetric(response);
        return response;
    }

    private void raiseSegmentCompletionProtocolResponseMetric(SegmentCompletionProtocol.Response response) {
        switch (response.getStatus()) {
            case NOT_SENT: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_NOT_SENT, 1L);
                break;
            }
            case COMMIT: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_COMMIT, 1L);
                break;
            }
            case HOLD: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_HOLD, 1L);
                break;
            }
            case CATCH_UP: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_CATCH_UP, 1L);
                break;
            }
            case DISCARD: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_DISCARD, 1L);
                break;
            }
            case KEEP: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_KEEP, 1L);
                break;
            }
            case NOT_LEADER: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_NOT_LEADER, 1L);
                break;
            }
            case FAILED: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_FAILED, 1L);
                break;
            }
            case COMMIT_SUCCESS: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_COMMIT_SUCCESS, 1L);
                break;
            }
            case COMMIT_CONTINUE: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_COMMIT_CONTINUE, 1L);
                break;
            }
            case PROCESSED: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_PROCESSED, 1L);
                break;
            }
            case UPLOAD_SUCCESS: {
                this._serverMetrics.addMeteredGlobalValue(ServerMeter.LLC_CONTROLLER_RESPONSE_UPLOAD_SUCCESS, 1L);
            }
        }
    }
}

