/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.startree.hll;

import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.collect.ImmutableBiMap;
import org.apache.pinot.$internal.com.google.common.collect.ImmutableMap;

public class HllSizeUtils {
    private static final ImmutableBiMap<Integer, Integer> LOG2M_TO_SIZE_IN_BYTES = ImmutableBiMap.of(5, 32, 6, 52, 7, 96, 8, 180, 9, 352);

    public static ImmutableBiMap<Integer, Integer> getLog2mToSizeInBytes() {
        return LOG2M_TO_SIZE_IN_BYTES;
    }

    public static int getHllFieldSizeFromLog2m(int log2m) {
        Preconditions.checkArgument(LOG2M_TO_SIZE_IN_BYTES.containsKey(log2m), "Log2m: " + log2m + " is not in valid range.");
        return (Integer)LOG2M_TO_SIZE_IN_BYTES.get(log2m);
    }

    public static int getLog2mFromHllFieldSize(int hllFieldSize) {
        Preconditions.checkArgument(LOG2M_TO_SIZE_IN_BYTES.containsValue(hllFieldSize), "HllFieldSize: " + hllFieldSize + " is not in valid range.");
        return (Integer)((ImmutableMap)((Object)LOG2M_TO_SIZE_IN_BYTES.inverse())).get(hllFieldSize);
    }
}

