/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageErrorCode;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageErrorHandler;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.table.TableStorageErrorDeserializer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;

public class StorageException
extends Exception {
    private static final long serialVersionUID = 7972747254288274928L;
    protected String errorCode;
    protected StorageExtendedErrorInformation extendedErrorInformation;
    private final int httpStatusCode;

    protected static StorageExtendedErrorInformation getErrorDetailsFromRequest(HttpURLConnection request, OperationContext opContext) {
        if (request == null || request.getErrorStream() == null) {
            return null;
        }
        try {
            return StorageErrorHandler.getExtendedErrorInformation(request.getErrorStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static StorageExtendedErrorInformation getErrorDetailsFromTableRequest(HttpURLConnection request, TablePayloadFormat format, OperationContext opContext) {
        if (request == null || request.getErrorStream() == null) {
            return null;
        }
        try {
            return TableStorageErrorDeserializer.getExtendedErrorInformation(new InputStreamReader(request.getErrorStream()), format);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StorageException translateException(HttpURLConnection request, Exception cause, OperationContext opContext) {
        if (request == null) {
            return new StorageException("Client error", "A Client side exception occurred, please check the inner exception for details", 306, null, cause);
        }
        if (cause instanceof SocketException) {
            return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "An unknown failure occurred : ".concat(cause.getMessage()), 500, null, cause);
        }
        StorageExtendedErrorInformation extendedError = null;
        try {
            String type;
            String server = request.getHeaderField("Server");
            extendedError = server != null && server.startsWith("Windows-Azure-Table") ? ((type = request.getHeaderField("Content-Type")) != null && type.startsWith("application/json") ? StorageException.getErrorDetailsFromTableRequest(request, TablePayloadFormat.Json, opContext) : StorageException.getErrorDetailsFromTableRequest(request, TablePayloadFormat.AtomPub, opContext)) : StorageException.getErrorDetailsFromRequest(request, opContext);
        }
        catch (Exception e) {
            // empty catch block
        }
        StorageException translatedException = null;
        String responseMessage = "";
        int responseCode = 0;
        try {
            responseCode = request.getResponseCode();
            responseMessage = request.getResponseMessage();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (responseMessage == null) {
            responseMessage = "";
        }
        if (extendedError != null && (translatedException = new StorageException(extendedError.getErrorCode(), responseMessage, responseCode, extendedError, cause)) != null) {
            return translatedException;
        }
        translatedException = StorageException.translateFromHttpStatus(responseCode, responseMessage, null, cause);
        if (translatedException != null) {
            return translatedException;
        }
        return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "The server encountered an unknown failure: ".concat(responseMessage), 500, null, cause);
    }

    protected static StorageException translateFromHttpStatus(int statusCode, String statusDescription, StorageExtendedErrorInformation details, Exception inner) {
        switch (statusCode) {
            case 403: {
                return new StorageException(StorageErrorCode.ACCESS_DENIED.toString(), statusDescription, statusCode, details, inner);
            }
            case 404: 
            case 410: {
                return new StorageException(StorageErrorCode.RESOURCE_NOT_FOUND.toString(), statusDescription, statusCode, details, inner);
            }
            case 400: {
                return new StorageException(StorageErrorCode.BAD_REQUEST.toString(), statusDescription, statusCode, details, inner);
            }
            case 304: 
            case 412: {
                return new StorageException(StorageErrorCode.CONDITION_FAILED.toString(), statusDescription, statusCode, details, inner);
            }
            case 409: {
                return new StorageException(StorageErrorCode.RESOURCE_ALREADY_EXISTS.toString(), statusDescription, statusCode, details, inner);
            }
            case 503: {
                return new StorageException(StorageErrorCode.SERVER_BUSY.toString(), statusDescription, statusCode, details, inner);
            }
            case 504: {
                return new StorageException(StorageErrorCode.SERVICE_TIMEOUT.toString(), statusDescription, statusCode, details, inner);
            }
            case 416: {
                return new StorageException(StorageErrorCode.BAD_REQUEST.toString(), statusDescription, statusCode, details, inner);
            }
            case 500: {
                return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), statusDescription, statusCode, details, inner);
            }
            case 501: {
                return new StorageException(StorageErrorCode.NOT_IMPLEMENTED.toString(), statusDescription, statusCode, details, inner);
            }
            case 502: {
                return new StorageException(StorageErrorCode.BAD_GATEWAY.toString(), statusDescription, statusCode, details, inner);
            }
            case 505: {
                return new StorageException(StorageErrorCode.HTTP_VERSION_NOT_SUPPORTED.toString(), statusDescription, statusCode, details, inner);
            }
        }
        return null;
    }

    public StorageException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(message, innerException);
        this.errorCode = errorCode;
        this.httpStatusCode = statusCode;
        this.extendedErrorInformation = extendedErrorInfo;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() {
        return this.extendedErrorInformation;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

