/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class JdbcPageSink
implements ConnectorPageSink {
    private static final Logger log = Logger.get(JdbcPageSink.class);
    private final Connection connection;
    private final PreparedStatement statement;
    private final List<Type> columnTypes;
    private int batchSize;

    public JdbcPageSink(ConnectorSession session, JdbcOutputTableHandle handle, JdbcClient jdbcClient) {
        try {
            this.connection = jdbcClient.getConnection(JdbcIdentity.from(session), handle);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            this.connection.setAutoCommit(false);
            this.statement = this.connection.prepareStatement(jdbcClient.buildInsertSql(handle));
        }
        catch (SQLException e) {
            JdbcPageSink.closeWithSuppression(this.connection, e);
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        this.columnTypes = handle.getColumnTypes();
    }

    public CompletableFuture<?> appendPage(Page page) {
        try {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    this.appendColumn(page, position, channel);
                }
                this.statement.addBatch();
                ++this.batchSize;
                if (this.batchSize < 1000) continue;
                this.statement.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(false);
                this.batchSize = 0;
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(Page page, int position, int channel) throws SQLException {
        Block block = page.getBlock(channel);
        int parameter = channel + 1;
        if (block.isNull(position)) {
            this.statement.setObject(parameter, null);
            return;
        }
        Type type = this.columnTypes.get(channel);
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.statement.setBoolean(parameter, type.getBoolean(block, position));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.statement.setLong(parameter, type.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            this.statement.setInt(parameter, Math.toIntExact(type.getLong(block, position)));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            this.statement.setShort(parameter, Shorts.checkedCast((long)type.getLong(block, position)));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            this.statement.setByte(parameter, SignedBytes.checkedCast((long)type.getLong(block, position)));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.statement.setDouble(parameter, type.getDouble(block, position));
        } else if (RealType.REAL.equals((Object)type)) {
            this.statement.setFloat(parameter, Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
        } else if (type instanceof DecimalType) {
            this.statement.setBigDecimal(parameter, Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)position));
        } else if (Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type)) {
            this.statement.setString(parameter, type.getSlice(block, position).toStringUtf8());
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            this.statement.setBytes(parameter, type.getSlice(block, position).getBytes());
        } else if (DateType.DATE.equals((Object)type)) {
            long utcMillis = TimeUnit.DAYS.toMillis(type.getLong(block, position));
            long localMillis = ISOChronology.getInstanceUTC().getZone().getMillisKeepLocal(DateTimeZone.getDefault(), utcMillis);
            this.statement.setDate(parameter, new Date(localMillis));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            if (this.batchSize > 0) {
                statement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLNonTransientException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            connection.rollback();
        }
        catch (SQLException e) {
            log.debug((Throwable)e, "SQLException when abort");
        }
    }

    private static void closeWithSuppression(Connection connection, Throwable throwable) {
        block2: {
            try {
                connection.close();
            }
            catch (Throwable t) {
                if (throwable == t) break block2;
                throwable.addSuppressed(t);
            }
        }
    }
}

