/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JmxTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName tableName;
    private final List<String> objectNames;
    private final List<JmxColumnHandle> columnHandles;
    private final boolean liveData;

    @JsonCreator
    public JmxTableHandle(@JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="objectNames") List<String> objectNames, @JsonProperty(value="columnHandles") List<JmxColumnHandle> columnHandles, @JsonProperty(value="liveData") boolean liveData) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.objectNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(objectNames, "objectName is null"));
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        this.liveData = liveData;
        Preconditions.checkArgument((!objectNames.isEmpty() ? 1 : 0) != 0, (Object)"objectsNames is empty");
    }

    @JsonProperty
    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getObjectNames() {
        return this.objectNames;
    }

    @JsonProperty
    public List<JmxColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public boolean isLiveData() {
        return this.liveData;
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.objectNames, this.columnHandles, this.liveData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmxTableHandle other = (JmxTableHandle)obj;
        return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.objectNames, other.objectNames) && Objects.equals(this.columnHandles, other.columnHandles) && Objects.equals(this.liveData, other.liveData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", this.objectNames).add("objectNames", this.objectNames).add("columnHandles", this.columnHandles).add("liveData", this.liveData).toString();
    }

    public ConnectorTableMetadata getTableMetadata() {
        return new ConnectorTableMetadata(this.tableName, (List)ImmutableList.copyOf((Iterable)Iterables.transform(this.columnHandles, JmxColumnHandle::getColumnMetadata)));
    }
}

