/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch.util;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static Predicate<NullableValue> convertToPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        TupleDomain<ColumnHandle> columnPredicate = PredicateUtils.filterColumns(predicate, columnHandle::equals);
        return nullableValue -> columnPredicate.contains(TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)nullableValue)));
    }

    public static TupleDomain<ColumnHandle> filterOutColumnFromPredicate(TupleDomain<ColumnHandle> predicate, TpchColumnHandle columnHandle) {
        return PredicateUtils.filterColumns(predicate, tpchColumnHandle -> !tpchColumnHandle.equals(columnHandle));
    }

    public static TupleDomain<ColumnHandle> filterColumns(TupleDomain<ColumnHandle> predicate, Predicate<TpchColumnHandle> filterPredicate) {
        return predicate.transform(columnHandle -> {
            TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
            if (filterPredicate.test(tpchColumnHandle)) {
                return tpchColumnHandle;
            }
            return null;
        });
    }
}

