/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.util.LinkedList;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.index.seqno.SeqNoStats;

public class LocalCheckpointTracker {
    static final int BIT_ARRAYS_SIZE = 1024;
    final LinkedList<FixedBitSet> processedSeqNo = new LinkedList();
    long firstProcessedSeqNo;
    volatile long checkpoint;
    private volatile long nextSeqNo;

    public LocalCheckpointTracker(long maxSeqNo, long localCheckpoint) {
        if (localCheckpoint < 0L && localCheckpoint != -1L) {
            throw new IllegalArgumentException("local checkpoint must be non-negative or [-1] but was [" + localCheckpoint + "]");
        }
        if (maxSeqNo < 0L && maxSeqNo != -1L) {
            throw new IllegalArgumentException("max seq. no. must be non-negative or [-1] but was [" + maxSeqNo + "]");
        }
        this.firstProcessedSeqNo = localCheckpoint == -1L ? 0L : localCheckpoint + 1L;
        this.nextSeqNo = maxSeqNo == -1L ? 0L : maxSeqNo + 1L;
        this.checkpoint = localCheckpoint;
    }

    synchronized long generateSeqNo() {
        return this.nextSeqNo++;
    }

    public synchronized void markSeqNoAsCompleted(long seqNo) {
        if (seqNo >= this.nextSeqNo) {
            this.nextSeqNo = seqNo + 1L;
        }
        if (seqNo <= this.checkpoint) {
            return;
        }
        FixedBitSet bitSet = this.getBitSetForSeqNo(seqNo);
        int offset = this.seqNoToBitSetOffset(seqNo);
        bitSet.set(offset);
        if (seqNo == this.checkpoint + 1L) {
            this.updateCheckpoint();
        }
    }

    synchronized void resetCheckpoint(long checkpoint) {
        assert (checkpoint != -2L);
        assert (checkpoint <= this.checkpoint);
        this.processedSeqNo.clear();
        this.firstProcessedSeqNo = checkpoint + 1L;
        this.checkpoint = checkpoint;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    long getMaxSeqNo() {
        return this.nextSeqNo - 1L;
    }

    synchronized SeqNoStats getStats(long globalCheckpoint) {
        return new SeqNoStats(this.getMaxSeqNo(), this.getCheckpoint(), globalCheckpoint);
    }

    @SuppressForbidden(reason="Object#wait")
    synchronized void waitForOpsToComplete(long seqNo) throws InterruptedException {
        while (this.checkpoint < seqNo) {
            this.wait();
        }
    }

    @SuppressForbidden(reason="Object#notifyAll")
    private void updateCheckpoint() {
        assert (Thread.holdsLock(this));
        assert (this.checkpoint < this.firstProcessedSeqNo + 1024L - 1L) : "checkpoint should be below the end of the first bit set (o.w. current bit set is completed and shouldn't be there)";
        assert (this.getBitSetForSeqNo(this.checkpoint + 1L) == this.processedSeqNo.getFirst()) : "checkpoint + 1 doesn't point to the first bit set (o.w. current bit set is completed and shouldn't be there)";
        assert (this.getBitSetForSeqNo(this.checkpoint + 1L).get(this.seqNoToBitSetOffset(this.checkpoint + 1L))) : "updateCheckpoint is called but the bit following the checkpoint is not set";
        try {
            FixedBitSet current = this.processedSeqNo.getFirst();
            do {
                ++this.checkpoint;
                if (this.checkpoint != this.firstProcessedSeqNo + 1024L - 1L) continue;
                this.processedSeqNo.removeFirst();
                this.firstProcessedSeqNo += 1024L;
                assert (this.checkpoint - this.firstProcessedSeqNo < 1024L);
                current = this.processedSeqNo.peekFirst();
            } while (current != null && current.get(this.seqNoToBitSetOffset(this.checkpoint + 1L)));
        }
        finally {
            this.notifyAll();
        }
    }

    private FixedBitSet getBitSetForSeqNo(long seqNo) {
        assert (Thread.holdsLock(this));
        assert (seqNo >= this.firstProcessedSeqNo) : "seqNo: " + seqNo + " firstProcessedSeqNo: " + this.firstProcessedSeqNo;
        long bitSetOffset = (seqNo - this.firstProcessedSeqNo) / 1024L;
        if (bitSetOffset > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("sequence number too high; got [" + seqNo + "], firstProcessedSeqNo [" + this.firstProcessedSeqNo + "]");
        }
        while (bitSetOffset >= (long)this.processedSeqNo.size()) {
            this.processedSeqNo.add(new FixedBitSet(1024));
        }
        return this.processedSeqNo.get((int)bitSetOffset);
    }

    private int seqNoToBitSetOffset(long seqNo) {
        assert (Thread.holdsLock(this));
        assert (seqNo >= this.firstProcessedSeqNo);
        return (int)(seqNo - this.firstProcessedSeqNo) % 1024;
    }
}

