/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

public final class ParentFieldSubFetchPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        ParentFieldMapper parentFieldMapper = context.mapperService().documentMapper(hitContext.hit().getType()).parentFieldMapper();
        if (!parentFieldMapper.active()) {
            return;
        }
        String parentId = ParentFieldSubFetchPhase.getParentId(parentFieldMapper, hitContext.reader(), hitContext.docId());
        if (parentId == null) {
            return;
        }
        Map<String, DocumentField> fields = hitContext.hit().fieldsOrNull();
        if (fields == null) {
            fields = new HashMap<String, DocumentField>();
            hitContext.hit().fields(fields);
        }
        fields.put("_parent", new DocumentField("_parent", Collections.singletonList(parentId)));
    }

    public static String getParentId(ParentFieldMapper fieldMapper, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(fieldMapper.name());
            if (docValues == null || !docValues.advanceExact(docId)) {
                return null;
            }
            BytesRef parentId = docValues.binaryValue();
            return parentId.length > 0 ? parentId.utf8ToString() : null;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

