/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.plain.PlainValuesReader;

public class FloatDictionary
extends Dictionary {
    private final float[] content;

    public FloatDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new float[dictionaryPage.getDictionarySize()];
        PlainValuesReader.FloatPlainValuesReader floatReader = new PlainValuesReader.FloatPlainValuesReader();
        ByteBuffer byteBuffer = ByteBuffer.wrap(dictionaryPage.getSlice().getBytes());
        ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)byteBuffer));
        floatReader.initFromPage(dictionaryPage.getDictionarySize(), inputStream);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = floatReader.readFloat();
        }
    }

    @Override
    public float decodeToFloat(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

