/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.plain.PlainValuesReader;

public class LongDictionary
extends Dictionary {
    private final long[] content;

    public LongDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new long[dictionaryPage.getDictionarySize()];
        PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
        ByteBuffer byteBuffer = ByteBuffer.wrap(dictionaryPage.getSlice().getBytes());
        ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)byteBuffer));
        longReader.initFromPage(dictionaryPage.getDictionarySize(), inputStream);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = longReader.readLong();
        }
    }

    @Override
    public long decodeToLong(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

