/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.PrimitiveColumnReader;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.apache.parquet.io.api.Binary;

public class BinaryColumnReader
extends PrimitiveColumnReader {
    public BinaryColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            Slice value = binary.length() == 0 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])binary.getBytes());
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            if (Chars.isCharType((Type)type)) {
                value = Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
            }
            type.writeSlice(blockBuilder, value);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

