/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.MetadataReader;
import com.facebook.presto.parquet.reader.PageReader;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;

public class ParquetColumnChunk
extends ByteArrayInputStream {
    private final ColumnChunkDescriptor descriptor;

    public ParquetColumnChunk(ColumnChunkDescriptor descriptor, byte[] data, int offset) {
        super(data);
        this.descriptor = descriptor;
        this.pos = offset;
    }

    public ColumnChunkDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected PageHeader readPageHeader() throws IOException {
        return Util.readPageHeader((InputStream)this);
    }

    public PageReader readAllPages() throws IOException {
        ArrayList<DataPage> pages = new ArrayList<DataPage>();
        DictionaryPage dictionaryPage = null;
        long valueCount = 0L;
        block5: while (valueCount < this.descriptor.getColumnChunkMetaData().getValueCount()) {
            PageHeader pageHeader = this.readPageHeader();
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new ParquetCorruptionException("%s has more than one dictionary page in column chunk", this.descriptor.getColumnDescriptor());
                    }
                    dictionaryPage = this.readDictionaryPage(pageHeader, uncompressedPageSize, compressedPageSize);
                    continue block5;
                }
                case DATA_PAGE: {
                    valueCount += this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, pages);
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    valueCount += this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, pages);
                    continue block5;
                }
            }
            this.skip(compressedPageSize);
        }
        return new PageReader(this.descriptor.getColumnChunkMetaData().getCodec(), pages, dictionaryPage);
    }

    public int getPosition() {
        return this.pos;
    }

    private Slice getSlice(int size) {
        Slice slice = Slices.wrappedBuffer((byte[])this.buf, (int)this.pos, (int)size);
        this.pos += size;
        return slice;
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) {
        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.getSlice(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name())));
    }

    private long readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages) {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        pages.add(new DataPageV1(this.getSlice(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, MetadataReader.readStats(dataHeaderV1.getStatistics(), this.descriptor.getColumnDescriptor().getType()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getEncoding().name()))));
        return dataHeaderV1.getNum_values();
    }

    private long readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages) {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        pages.add(new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.getSlice(dataHeaderV2.getRepetition_levels_byte_length()), this.getSlice(dataHeaderV2.getDefinition_levels_byte_length()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV2.getEncoding().name())), this.getSlice(dataSize), uncompressedPageSize, MetadataReader.readStats(dataHeaderV2.getStatistics(), this.descriptor.getColumnDescriptor().getType()), dataHeaderV2.isIs_compressed()));
        return dataHeaderV2.getNum_values();
    }
}

