/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.coercion;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.TypeCoercion;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CoercionThriftCodec<T>
implements ThriftCodec<T> {
    private final ThriftCodec<Object> codec;
    private final TypeCoercion typeCoercion;
    private final ThriftType thriftType;

    public CoercionThriftCodec(ThriftCodec<?> codec, TypeCoercion typeCoercion) {
        this.codec = codec;
        this.typeCoercion = typeCoercion;
        this.thriftType = typeCoercion.getThriftType();
    }

    @Override
    public ThriftType getType() {
        return this.thriftType;
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        Object thriftValue = this.codec.read(protocol);
        return (T)this.typeCoercion.getFromThrift().invoke(null, thriftValue);
    }

    @Override
    public void write(T javaValue, TProtocolWriter protocol) throws Exception {
        Object thriftValue = this.typeCoercion.getToThrift().invoke(null, javaValue);
        this.codec.write(thriftValue, protocol);
    }
}

