/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapred.FileSplit;

public class HoodieRealtimeFileSplit
extends FileSplit {
    private List<String> deltaLogPaths;
    private String maxCommitTime;
    private String basePath;

    public HoodieRealtimeFileSplit() {
    }

    public HoodieRealtimeFileSplit(FileSplit baseSplit, String basePath, List<String> deltaLogPaths, String maxCommitTime) throws IOException {
        super(baseSplit.getPath(), baseSplit.getStart(), baseSplit.getLength(), baseSplit.getLocations());
        this.deltaLogPaths = deltaLogPaths;
        this.maxCommitTime = maxCommitTime;
        this.basePath = basePath;
    }

    public List<String> getDeltaLogPaths() {
        return this.deltaLogPaths;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public String getBasePath() {
        return this.basePath;
    }

    private static void writeString(String str, DataOutput out) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private static String readString(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        HoodieRealtimeFileSplit.writeString(this.basePath, out);
        HoodieRealtimeFileSplit.writeString(this.maxCommitTime, out);
        out.writeInt(this.deltaLogPaths.size());
        for (String logFilePath : this.deltaLogPaths) {
            HoodieRealtimeFileSplit.writeString(logFilePath, out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.basePath = HoodieRealtimeFileSplit.readString(in);
        this.maxCommitTime = HoodieRealtimeFileSplit.readString(in);
        int totalLogFiles = in.readInt();
        this.deltaLogPaths = new ArrayList<String>(totalLogFiles);
        for (int i = 0; i < totalLogFiles; ++i) {
            this.deltaLogPaths.add(HoodieRealtimeFileSplit.readString(in));
        }
    }

    public String toString() {
        return "HoodieRealtimeFileSplit{DataPath=" + this.getPath() + ", deltaLogPaths=" + this.deltaLogPaths + ", maxCommitTime='" + this.maxCommitTime + '\'' + ", basePath='" + this.basePath + '\'' + '}';
    }
}

