/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationUtil {
    public static String getMandatoryConfig(Configuration config, String key) throws IOException {
        String value = config.get(key);
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IOException("Must supply a value for configuration setting: " + key);
        }
        return value;
    }

    public static Map<String, String> getMandatoryConfig(Configuration config, List<String> keys) throws IOException {
        ArrayList<String> missingKeys = new ArrayList<String>();
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : keys) {
            String value = config.get(key);
            if (Strings.isNullOrEmpty((String)value)) {
                missingKeys.add(key);
                continue;
            }
            values.put(key, value);
        }
        if (missingKeys.size() > 0) {
            Joiner joiner = Joiner.on((String)", ");
            String message = "Must supply value for configuration settings: " + joiner.join(missingKeys);
            throw new IOException(message);
        }
        return values;
    }
}

