/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial;

import com.esri.core.geometry.Envelope;
import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.plugin.geospatial.SpatialPartitioningState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class SpatialPartitioningStateFactory
implements AccumulatorStateFactory<SpatialPartitioningState> {
    public SpatialPartitioningState createSingleState() {
        return new SingleSpatialPartitioningState();
    }

    public Class getSingleStateClass() {
        return SpatialPartitioningState.class;
    }

    public SpatialPartitioningState createGroupedState() {
        return new GroupedSpatialPartitioningState();
    }

    public Class getGroupedStateClass() {
        return GroupedSpatialPartitioningState.class;
    }

    public static final class SingleSpatialPartitioningState
    implements SpatialPartitioningState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleSpatialPartitioningState.class).instanceSize();
        private int partitionCount;
        private long count;
        private Rectangle envelope;
        private List<Rectangle> samples = new ArrayList<Rectangle>();

        @Override
        public int getPartitionCount() {
            return this.partitionCount;
        }

        @Override
        public void setPartitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void setCount(long count) {
            this.count = count;
        }

        @Override
        public Rectangle getExtent() {
            return this.envelope;
        }

        @Override
        public void setExtent(Rectangle envelope) {
            this.envelope = envelope;
        }

        @Override
        public List<Rectangle> getSamples() {
            return this.samples;
        }

        @Override
        public void setSamples(List<Rectangle> samples) {
            this.samples = samples;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + (this.envelope != null ? this.envelope.getEstimatedSizeInBytes() * (long)(1 + this.samples.size()) : 0L);
        }
    }

    public static final class GroupedSpatialPartitioningState
    implements GroupedAccumulatorState,
    SpatialPartitioningState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedSpatialPartitioningState.class).instanceSize();
        private static final int ENVELOPE_SIZE = Math.toIntExact(new Envelope(1.0, 2.0, 3.0, 4.0).estimateMemorySize());
        private long groupId;
        private final IntBigArray partitionCounts = new IntBigArray();
        private final LongBigArray counts = new LongBigArray();
        private final ObjectBigArray<Rectangle> envelopes = new ObjectBigArray();
        private final ObjectBigArray<List<Rectangle>> samples = new ObjectBigArray();
        private int envelopeCount;
        private int samplesCount;

        @Override
        public int getPartitionCount() {
            return this.partitionCounts.get(this.groupId);
        }

        @Override
        public void setPartitionCount(int partitionCount) {
            this.partitionCounts.set(this.groupId, partitionCount);
        }

        @Override
        public long getCount() {
            return this.counts.get(this.groupId);
        }

        @Override
        public void setCount(long count) {
            this.counts.set(this.groupId, count);
        }

        @Override
        public Rectangle getExtent() {
            return (Rectangle)this.envelopes.get(this.groupId);
        }

        @Override
        public void setExtent(Rectangle envelope) {
            if (this.envelopes.get(this.groupId) == null) {
                ++this.envelopeCount;
            }
            this.envelopes.set(this.groupId, (Object)envelope);
        }

        @Override
        public List<Rectangle> getSamples() {
            return (List)this.samples.get(this.groupId);
        }

        @Override
        public void setSamples(List<Rectangle> samples) {
            List currentSamples = (List)this.samples.get(this.groupId);
            if (currentSamples != null) {
                this.samplesCount -= currentSamples.size();
            }
            this.samplesCount += samples.size();
            this.samples.set(this.groupId, samples);
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.partitionCounts.sizeOf() + this.counts.sizeOf() + this.envelopes.sizeOf() + this.samples.sizeOf() + (long)(ENVELOPE_SIZE * (this.envelopeCount + this.samplesCount));
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(long size) {
            this.partitionCounts.ensureCapacity(size);
            this.counts.ensureCapacity(size);
            this.envelopes.ensureCapacity(size);
            this.samples.ensureCapacity(size);
        }
    }
}

