/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.plugin.geospatial.GeometryType;
import com.facebook.presto.plugin.geospatial.aggregation.GeometryState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

@Description(value="Returns a geometry that represents the point set union of the input geometries.")
@AggregationFunction(value="geometry_union_agg")
public class GeometryUnionAgg {
    private GeometryUnionAgg() {
    }

    @InputFunction
    public static void input(@AggregationState GeometryState state, @SqlType(value="Geometry") Slice input) {
        OGCGeometry geometry = EsriGeometrySerde.deserialize((Slice)input);
        if (state.getGeometry() == null) {
            state.setGeometry(geometry, 0L);
        } else if (!geometry.isEmpty()) {
            long previousMemorySize = state.getGeometry().estimateMemorySize();
            state.setGeometry(state.getGeometry().union(geometry), previousMemorySize);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState GeometryState state, @AggregationState GeometryState otherState) {
        if (state.getGeometry() == null) {
            state.setGeometry(otherState.getGeometry(), 0L);
        } else if (otherState.getGeometry() != null && !otherState.getGeometry().isEmpty()) {
            long previousMemorySize = state.getGeometry().estimateMemorySize();
            state.setGeometry(state.getGeometry().union(otherState.getGeometry()), previousMemorySize);
        }
    }

    @OutputFunction(value="Geometry")
    public static void output(@AggregationState GeometryState state, BlockBuilder out) {
        if (state.getGeometry() == null) {
            out.appendNull();
        } else {
            GeometryType.GEOMETRY.writeSlice(out, EsriGeometrySerde.serialize((OGCGeometry)state.getGeometry()));
        }
    }
}

