/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.CheckpointPOptions;
import alluxio.grpc.GetConfigReportPOptions;
import alluxio.grpc.GetMasterInfoPOptions;
import alluxio.grpc.GetMetricsPOptions;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.MasterInfoField;
import alluxio.grpc.MetaMasterClientServiceGrpc;
import alluxio.grpc.MetricValue;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BackupResponse;
import alluxio.wire.ConfigCheckReport;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class RetryHandlingMetaMasterClient
extends AbstractMasterClient
implements MetaMasterClient {
    private MetaMasterClientServiceGrpc.MetaMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetaMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetaMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public BackupResponse backup(BackupPOptions options) throws IOException {
        return this.retryRPC(() -> BackupResponse.fromProto(this.mClient.backup(options)));
    }

    @Override
    public ConfigCheckReport getConfigReport() throws IOException {
        return this.retryRPC(() -> ConfigCheckReport.fromProto(this.mClient.getConfigReport(GetConfigReportPOptions.getDefaultInstance()).getReport()));
    }

    @Override
    public MasterInfo getMasterInfo(Set<MasterInfoField> fields) throws IOException {
        return this.retryRPC(() -> this.mClient.getMasterInfo(GetMasterInfoPOptions.newBuilder().addAllFilter(fields).build()).getMasterInfo());
    }

    @Override
    public Map<String, MetricValue> getMetrics() throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getMetrics(GetMetricsPOptions.getDefaultInstance()).getMetricsMap());
    }

    @Override
    public String checkpoint() throws IOException {
        return this.retryRPC(() -> this.mClient.checkpoint(CheckpointPOptions.newBuilder().build()).getMasterHostname());
    }
}

