/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.collections.Pair;
import alluxio.grpc.GrpcChannelKey;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.netty.NettyChannelBuilder;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GrpcManagedChannelPool {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcManagedChannelPool.class);
    private static GrpcManagedChannelPool sInstance = new GrpcManagedChannelPool();
    private ConcurrentMap<GrpcChannelKey, ManagedChannelHolder> mChannels = new ConcurrentHashMap<GrpcChannelKey, ManagedChannelHolder>();

    public static GrpcManagedChannelPool INSTANCE() {
        return sInstance;
    }

    public ManagedChannel acquireManagedChannel(GrpcChannelKey channelKey, long healthCheckTimeoutMs, long shutdownTimeoutMs) {
        return this.mChannels.compute(channelKey, (key, chHolder) -> {
            boolean shutdownExistingChannel = false;
            int existingRefCount = 0;
            if (chHolder != null) {
                if (this.waitForChannelReady(((ManagedChannelHolder)chHolder).get(), healthCheckTimeoutMs)) {
                    GrpcManagedChannelPool.LOG.debug("Acquiring an existing managed channel. ChannelKey: {}. Ref-count: {}", key, (Object)((ManagedChannelHolder)chHolder).getRefCount());
                    return ((ManagedChannelHolder)chHolder).reference();
                }
                shutdownExistingChannel = true;
            }
            if (shutdownExistingChannel) {
                existingRefCount = ((ManagedChannelHolder)chHolder).getRefCount();
                GrpcManagedChannelPool.LOG.debug("Shutting down an existing unhealthy managed channel. ChannelKey: {}. Existing Ref-count: {}", key, (Object)existingRefCount);
                this.forceShutdownManagedChannel(((ManagedChannelHolder)chHolder).get(), shutdownTimeoutMs);
            }
            GrpcManagedChannelPool.LOG.debug("Creating a new managed channel. ChannelKey: {}. Ref-count:{}", key, (Object)existingRefCount);
            return new ManagedChannelHolder(this.createManagedChannel((GrpcChannelKey)key), existingRefCount).reference();
        }).get();
    }

    public void releaseManagedChannel(GrpcChannelKey channelKey, long shutdownTimeoutMs) {
        this.mChannels.compute(channelKey, (key, chHolder) -> {
            Preconditions.checkNotNull(chHolder, "Releasing nonexistent channel");
            if (((ManagedChannelHolder)chHolder).dereference() == 0) {
                LOG.debug("Released managed channel for: {}. Ref-count: {}", key, (Object)((ManagedChannelHolder)chHolder).getRefCount());
                this.shutdownManagedChannel(((ManagedChannelHolder)chHolder).get(), shutdownTimeoutMs);
                return null;
            }
            return chHolder;
        });
    }

    private ManagedChannel createManagedChannel(GrpcChannelKey channelKey) {
        Optional<EventLoopGroup> eventLoopGroup;
        Optional<Class<? extends Channel>> channelType;
        Optional<Integer> flowControlWindow;
        Optional<Integer> maxInboundMsgSize;
        Optional<Pair<Long, TimeUnit>> keepAliveTimeout;
        NettyChannelBuilder channelBuilder;
        SocketAddress address = channelKey.getServerAddress().getSocketAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetServerAddress = (InetSocketAddress)address;
            channelBuilder = NettyChannelBuilder.forAddress(inetServerAddress.getHostName(), inetServerAddress.getPort());
        } else {
            channelBuilder = NettyChannelBuilder.forAddress(address);
        }
        Optional<Pair<Long, TimeUnit>> keepAliveTime = channelKey.getKeepAliveTime();
        if (keepAliveTime.isPresent()) {
            channelBuilder.keepAliveTime(keepAliveTime.get().getFirst(), keepAliveTime.get().getSecond());
        }
        if ((keepAliveTimeout = channelKey.getKeepAliveTimeout()).isPresent()) {
            channelBuilder.keepAliveTimeout(keepAliveTimeout.get().getFirst(), keepAliveTimeout.get().getSecond());
        }
        if ((maxInboundMsgSize = channelKey.getMaxInboundMessageSize()).isPresent()) {
            channelBuilder.maxInboundMessageSize(maxInboundMsgSize.get());
        }
        if ((flowControlWindow = channelKey.getFlowControlWindow()).isPresent()) {
            channelBuilder.flowControlWindow(flowControlWindow.get());
        }
        if ((channelType = channelKey.getChannelType()).isPresent()) {
            channelBuilder.channelType(channelType.get());
        }
        if ((eventLoopGroup = channelKey.getEventLoopGroup()).isPresent()) {
            channelBuilder.eventLoopGroup(eventLoopGroup.get());
        }
        channelBuilder.usePlaintext();
        return channelBuilder.build();
    }

    private boolean waitForChannelReady(ManagedChannel managedChannel, long healthCheckTimeoutMs) {
        try {
            Boolean res = CommonUtils.waitForResult("channel to be ready", () -> {
                ConnectivityState currentState = managedChannel.getState(true);
                switch (currentState) {
                    case READY: {
                        return true;
                    }
                    case TRANSIENT_FAILURE: 
                    case SHUTDOWN: {
                        return false;
                    }
                    case IDLE: 
                    case CONNECTING: {
                        return null;
                    }
                }
                return null;
            }, WaitForOptions.defaults().setTimeoutMs((int)healthCheckTimeoutMs));
            return res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    private void shutdownManagedChannel(ManagedChannel managedChannel, long shutdownTimeoutMs) {
        managedChannel.shutdown();
        try {
            if (!managedChannel.awaitTermination(shutdownTimeoutMs, TimeUnit.MILLISECONDS)) {
                LOG.warn("Timed out gracefully shutting down managed channel: {}. ", (Object)managedChannel);
                this.forceShutdownManagedChannel(managedChannel, shutdownTimeoutMs);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void forceShutdownManagedChannel(ManagedChannel managedChannel, long shutdownTimeoutMs) {
        managedChannel.shutdownNow();
        try {
            if (!managedChannel.awaitTermination(shutdownTimeoutMs, TimeUnit.MILLISECONDS)) {
                LOG.warn("Timed out forcefully shutting down managed channel: {}. ", (Object)managedChannel);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class ManagedChannelHolder {
        private ManagedChannel mChannel;
        private AtomicInteger mRefCount;

        private ManagedChannelHolder(ManagedChannel channel, int refCount) {
            this.mChannel = channel;
            this.mRefCount = new AtomicInteger(refCount);
        }

        private ManagedChannelHolder reference() {
            this.mRefCount.incrementAndGet();
            return this;
        }

        private int dereference() {
            return this.mRefCount.decrementAndGet();
        }

        private int getRefCount() {
            return this.mRefCount.get();
        }

        private ManagedChannel get() {
            return this.mChannel;
        }
    }
}

