/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.AlluxioURI;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.MetricType;
import alluxio.metrics.Metric;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.sink.Sink;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Gauge;
import alluxio.shaded.client.com.codahale.metrics.JvmAttributeGaugeSet;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.codahale.metrics.MetricRegistry;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import alluxio.shaded.client.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import alluxio.shaded.client.com.google.common.base.Joiner;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetricsSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSystem.class);
    private static final ConcurrentHashMap<String, String> CACHED_METRICS = new ConcurrentHashMap();
    private static int sResolveTimeout = (int)new InstancedConfiguration(ConfigurationUtils.defaults()).getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
    private static final ConcurrentHashMap<String, Metric> LAST_REPORTED_METRICS = new ConcurrentHashMap();
    public static final String CLUSTER = "cluster";
    public static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();
    @GuardedBy(value="MetricsSystem")
    private static List<Sink> sSinks;
    public static final String SINK_REGEX = "^sink\\.(.+)\\.(.+)";
    private static final TimeUnit MINIMAL_POLL_UNIT;
    private static final int MINIMAL_POLL_PERIOD = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSinks(String metricsConfFile) {
        Class<MetricsSystem> clazz = MetricsSystem.class;
        synchronized (MetricsSystem.class) {
            if (sSinks != null) {
                LOG.info("Sinks have already been started.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (metricsConfFile.isEmpty()) {
                LOG.info("Metrics is not enabled.");
                return;
            }
            MetricsConfig config = new MetricsConfig(metricsConfFile);
            MetricsSystem.startSinksFromConfig(config);
            return;
        }
    }

    public static synchronized void startSinksFromConfig(MetricsConfig config) {
        if (sSinks != null) {
            LOG.info("Sinks have already been started.");
            return;
        }
        LOG.info("Starting sinks with config: {}.", (Object)config);
        sSinks = new ArrayList<Sink>();
        Map<String, Properties> sinkConfigs = MetricsConfig.subProperties(config.getProperties(), SINK_REGEX);
        for (Map.Entry<String, Properties> entry : sinkConfigs.entrySet()) {
            String classPath = entry.getValue().getProperty("class");
            if (classPath == null) continue;
            LOG.info("Starting sink {}.", (Object)classPath);
            try {
                Sink sink = (Sink)Class.forName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(entry.getValue(), METRIC_REGISTRY);
                sink.start();
                sSinks.add(sink);
            }
            catch (Exception e) {
                LOG.error("Sink class {} cannot be instantiated", (Object)classPath, (Object)e);
            }
        }
    }

    public static synchronized void stopSinks() {
        if (sSinks != null) {
            for (Sink sink : sSinks) {
                sink.stop();
            }
        }
        sSinks = null;
    }

    public static synchronized int getNumSinks() {
        int sz = 0;
        if (sSinks != null) {
            sz = sSinks.size();
        }
        return sz;
    }

    public static String getMetricName(String name) {
        switch (CommonUtils.PROCESS_TYPE.get()) {
            case CLIENT: {
                return MetricsSystem.getClientMetricName(name);
            }
            case MASTER: {
                return MetricsSystem.getMasterMetricName(name);
            }
            case PROXY: {
                return MetricsSystem.getProxyMetricName(name);
            }
            case WORKER: {
                return MetricsSystem.getWorkerMetricName(name);
            }
            case JOB_MASTER: {
                return MetricsSystem.getJobMasterMetricName(name);
            }
            case JOB_WORKER: {
                return MetricsSystem.getJobWorkerMetricName(name);
            }
        }
        throw new IllegalStateException("Unknown process type");
    }

    private static String getMasterMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> InstanceType.MASTER.toString() + "." + name);
    }

    private static String getWorkerMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> MetricsSystem.getMetricNameWithUniqueId(InstanceType.WORKER, name));
    }

    private static String getClientMetricName(String name) {
        String result = CACHED_METRICS.get(name);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(name, n -> MetricsSystem.getMetricNameWithUniqueId(InstanceType.CLIENT, name));
    }

    private static String getProxyMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(InstanceType.PROXY, name);
    }

    public static String getClusterMetricName(String name) {
        return Joiner.on(".").join(CLUSTER, name, new Object[0]);
    }

    private static String getJobMasterMetricName(String name) {
        return Joiner.on(".").join((Object)InstanceType.JOB_MASTER, name, new Object[0]);
    }

    public static String getJobWorkerMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(InstanceType.JOB_WORKER, name);
    }

    private static String getMetricNameWithUniqueId(InstanceType instance, String name) {
        return (Object)((Object)instance) + "." + NetworkAddressUtils.getLocalHostMetricName(sResolveTimeout) + "." + name;
    }

    public static void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) throws IllegalArgumentException {
        int period = (int)MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        Preconditions.checkArgument(period >= 1, "Polling period %d %d is below the minimal polling period", pollPeriod, (Object)pollUnit);
    }

    public static String stripInstanceAndHost(String metricsName) {
        Object[] pieces = metricsName.split("\\.");
        Preconditions.checkArgument(pieces.length > 1, "Incorrect metrics name: %s.", (Object)metricsName);
        if (!pieces[0].equals(InstanceType.MASTER.toString())) {
            pieces[1] = null;
        }
        pieces[0] = null;
        return Joiner.on(".").skipNulls().join(pieces);
    }

    public static String escape(AlluxioURI uri) {
        return uri.toString().replace("%", "%25").replace("/", "%2F").replace(".", "%2E");
    }

    public static String unescape(String uri) {
        return uri.replace("%2F", "/").replace("%2E", ".").replace("%25", "%");
    }

    public static Counter counter(String name) {
        return METRIC_REGISTRY.counter(MetricsSystem.getMetricName(name));
    }

    public static Meter meter(String name) {
        return METRIC_REGISTRY.meter(MetricsSystem.getMetricName(name));
    }

    public static Timer timer(String name) {
        return METRIC_REGISTRY.timer(MetricsSystem.getMetricName(name));
    }

    public static synchronized <T> void registerGaugeIfAbsent(String name, Gauge<T> metric) {
        if (!METRIC_REGISTRY.getGauges().containsKey(name)) {
            METRIC_REGISTRY.register(name, metric);
        }
    }

    public static void resetCountersAndGauges() {
        for (Map.Entry<String, Counter> entry : METRIC_REGISTRY.getCounters().entrySet()) {
            entry.getValue().dec(entry.getValue().getCount());
        }
        for (String gauge : METRIC_REGISTRY.getGauges().keySet()) {
            METRIC_REGISTRY.remove(gauge);
        }
    }

    private static List<alluxio.grpc.Metric> reportMetrics(InstanceType instanceType) {
        ArrayList<alluxio.grpc.Metric> rpcMetrics = new ArrayList<alluxio.grpc.Metric>(20);
        for (Metric m3 : MetricsSystem.allMetrics(instanceType)) {
            if (m3.getMetricType() == MetricType.COUNTER) {
                Metric prev = LAST_REPORTED_METRICS.replace(m3.getFullMetricName(), m3);
                if (prev == null) {
                    LAST_REPORTED_METRICS.put(m3.getFullMetricName(), m3);
                }
                double diff = prev != null ? m3.getValue() - prev.getValue() : m3.getValue();
                rpcMetrics.add(m3.toProto().toBuilder().setValue(diff).build());
                continue;
            }
            rpcMetrics.add(m3.toProto());
        }
        return rpcMetrics;
    }

    public static List<alluxio.grpc.Metric> reportWorkerMetrics() {
        return MetricsSystem.reportMetrics(InstanceType.WORKER);
    }

    public static List<alluxio.grpc.Metric> reportClientMetrics() {
        return MetricsSystem.reportMetrics(InstanceType.CLIENT);
    }

    public static List<Metric> allMasterMetrics() {
        return MetricsSystem.allMetrics(InstanceType.MASTER);
    }

    public static List<Metric> allWorkerMetrics() {
        return MetricsSystem.allMetrics(InstanceType.WORKER);
    }

    public static List<Metric> allClientMetrics() {
        return MetricsSystem.allMetrics(InstanceType.CLIENT);
    }

    private static List<Metric> allMetrics(InstanceType instanceType) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Map.Entry<String, Gauge> entry : METRIC_REGISTRY.getGauges().entrySet()) {
            if (!entry.getKey().startsWith(instanceType.toString())) continue;
            Object value = entry.getValue().getValue();
            if (!(value instanceof Number)) {
                LOG.warn("The value of metric {} of type {} is not sent to metrics master, only metrics value of number can be collected", (Object)entry.getKey(), (Object)entry.getValue().getClass().getSimpleName());
                continue;
            }
            metrics.add(Metric.from(entry.getKey(), ((Number)value).longValue(), MetricType.GAUGE));
        }
        for (Map.Entry<String, alluxio.shaded.client.com.codahale.metrics.Metric> entry : METRIC_REGISTRY.getCounters().entrySet()) {
            metrics.add(Metric.from(entry.getKey(), ((Counter)entry.getValue()).getCount(), MetricType.COUNTER));
        }
        for (Map.Entry<String, alluxio.shaded.client.com.codahale.metrics.Metric> entry : METRIC_REGISTRY.getMeters().entrySet()) {
            metrics.add(Metric.from(entry.getKey(), ((Meter)entry.getValue()).getOneMinuteRate(), MetricType.METER));
        }
        for (Map.Entry<String, alluxio.shaded.client.com.codahale.metrics.Metric> entry : METRIC_REGISTRY.getTimers().entrySet()) {
            metrics.add(Metric.from(entry.getKey(), ((Timer)entry.getValue()).getCount(), MetricType.TIMER));
        }
        return metrics;
    }

    public static void clearAllMetrics() {
        for (String name : METRIC_REGISTRY.getNames()) {
            METRIC_REGISTRY.remove(name);
        }
    }

    private MetricsSystem() {
    }

    static {
        METRIC_REGISTRY.registerAll(new JvmAttributeGaugeSet());
        METRIC_REGISTRY.registerAll(new GarbageCollectorMetricSet());
        METRIC_REGISTRY.registerAll(new MemoryUsageGaugeSet());
        MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
    }

    public static enum InstanceType {
        JOB_MASTER("JobMaster"),
        JOB_WORKER("JobWorker"),
        MASTER("Master"),
        WORKER("Worker"),
        CLUSTER("Cluster"),
        CLIENT("Client"),
        PROXY("Proxy");

        private String mValue;

        private InstanceType(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }

        public static InstanceType fromString(String text) {
            for (InstanceType type : InstanceType.values()) {
                if (!type.toString().equalsIgnoreCase(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("No constant with text " + text + " found");
        }
    }
}

