/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.aggregator;

import alluxio.metrics.Metric;
import alluxio.metrics.MetricsFilter;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.MultiValueMetricsAggregator;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleTagValueAggregator
implements MultiValueMetricsAggregator {
    private final MetricsSystem.InstanceType mInstanceType;
    private final String mAggregationName;
    private final String mMetricName;
    private final String mTagName;
    private final MetricsFilter mFilter;
    private Map<String, Long> mAggregates;

    public SingleTagValueAggregator(String aggregationName, MetricsSystem.InstanceType instanceType, String metricName, String tagName) {
        Preconditions.checkNotNull(aggregationName, "aggregationName");
        Preconditions.checkNotNull(instanceType, "instance type");
        Preconditions.checkNotNull(metricName, "metricName");
        Preconditions.checkNotNull(tagName, "tagName");
        this.mAggregationName = aggregationName;
        this.mInstanceType = instanceType;
        this.mMetricName = metricName;
        this.mTagName = tagName;
        this.mFilter = new MetricsFilter(this.mInstanceType, this.mMetricName);
        this.mAggregates = new HashMap<String, Long>();
    }

    @Override
    public List<MetricsFilter> getFilters() {
        return Lists.newArrayList(this.mFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> updateValues(Map<MetricsFilter, Set<Metric>> map) {
        HashMap<String, Long> updated = new HashMap<String, Long>();
        for (Metric metric : map.get(this.mFilter)) {
            Map<String, String> tags = metric.getTags();
            if (!tags.containsKey(this.mTagName)) continue;
            String ufsName = MetricsSystem.getClusterMetricName(Metric.getMetricNameWithTags(this.mAggregationName, this.mTagName, tags.get(this.mTagName)));
            long value = updated.getOrDefault(ufsName, 0L);
            updated.put(ufsName, (long)((double)value + metric.getValue()));
        }
        SingleTagValueAggregator singleTagValueAggregator = this;
        synchronized (singleTagValueAggregator) {
            this.mAggregates = updated;
        }
        return Collections.unmodifiableMap(this.mAggregates);
    }

    @Override
    public long getValue(String name) {
        return this.mAggregates.getOrDefault(name, 0L);
    }
}

