/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.common.util.concurrent;

import alluxio.shaded.client.com.google.common.annotations.GwtCompatible;
import alluxio.shaded.client.com.google.j2objc.annotations.ReflectionSupport;
import alluxio.shaded.client.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.concurrent.atomic.AtomicReference;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable INTERRUPTING = new DoNothingRunnable();

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread currentThread = Thread.currentThread();
        if (!this.compareAndSet(null, currentThread)) {
            return;
        }
        boolean run = !this.isDone();
        T result = null;
        Throwable error = null;
        try {
            if (run) {
                result = this.runInterruptibly();
            }
        }
        catch (Throwable t) {
            error = t;
        }
        finally {
            if (!this.compareAndSet(currentThread, DONE)) {
                while (this.get() == INTERRUPTING) {
                    Thread.yield();
                }
            }
            if (run) {
                this.afterRanInterruptibly(result, error);
            }
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(@Nullable T var1, @Nullable Throwable var2);

    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread && this.compareAndSet(currentRunner, INTERRUPTING)) {
            ((Thread)currentRunner).interrupt();
            this.set(DONE);
        }
    }

    @Override
    public final String toString() {
        Runnable state = (Runnable)this.get();
        String result = state == DONE ? "running=[DONE]" : (state == INTERRUPTING ? "running=[INTERRUPTED]" : (state instanceof Thread ? "running=[RUNNING ON " + ((Thread)state).getName() + "]" : "running=[NOT STARTED YET]"));
        return result + ", " + this.toPendingString();
    }

    abstract String toPendingString();

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

