/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.util.concurrent.MoreExecutors;
import alluxio.shaded.client.io.grpc.BinaryLog;
import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.CompressorRegistry;
import alluxio.shaded.client.io.grpc.Context;
import alluxio.shaded.client.io.grpc.DecompressorRegistry;
import alluxio.shaded.client.io.grpc.HandlerRegistry;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.InternalChannelz;
import alluxio.shaded.client.io.grpc.InternalNotifyOnServerBuild;
import alluxio.shaded.client.io.grpc.Server;
import alluxio.shaded.client.io.grpc.ServerBuilder;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.io.grpc.ServerMethodDefinition;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.ServerStreamTracer;
import alluxio.shaded.client.io.grpc.ServerTransportFilter;
import alluxio.shaded.client.io.grpc.internal.CallTracer;
import alluxio.shaded.client.io.grpc.internal.CensusStatsModule;
import alluxio.shaded.client.io.grpc.internal.CensusTracingModule;
import alluxio.shaded.client.io.grpc.internal.FixedObjectPool;
import alluxio.shaded.client.io.grpc.internal.GrpcUtil;
import alluxio.shaded.client.io.grpc.internal.InternalHandlerRegistry;
import alluxio.shaded.client.io.grpc.internal.InternalServer;
import alluxio.shaded.client.io.grpc.internal.ObjectPool;
import alluxio.shaded.client.io.grpc.internal.ServerImpl;
import alluxio.shaded.client.io.grpc.internal.SharedResourcePool;
import alluxio.shaded.client.io.grpc.internal.TransportTracer;
import alluxio.shaded.client.io.opencensus.trace.Tracing;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final HandlerRegistry DEFAULT_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(120L);
    final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    final List<ServerTransportFilter> transportFilters = new ArrayList<ServerTransportFilter>();
    final List<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    private final List<ServerStreamTracer.Factory> streamTracerFactories = new ArrayList<ServerStreamTracer.Factory>();
    HandlerRegistry fallbackRegistry = DEFAULT_FALLBACK_REGISTRY;
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long handshakeTimeoutMillis = DEFAULT_HANDSHAKE_TIMEOUT_MILLIS;
    @Nullable
    private CensusStatsModule censusStatsOverride;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean tracingEnabled = true;
    @Nullable
    protected BinaryLog binlog;
    protected TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    protected InternalChannelz channelz = InternalChannelz.instance();
    protected CallTracer.Factory callTracerFactory = CallTracer.getDefaultFactory();

    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add(Preconditions.checkNotNull(filter, "filter"));
        return this.thisT();
    }

    @Override
    public final T intercept(ServerInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.streamTracerFactories.add(Preconditions.checkNotNull(factory, "factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry != null ? registry : DEFAULT_FALLBACK_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry != null ? registry : DEFAULT_DECOMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry != null ? registry : DEFAULT_COMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T handshakeTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument(timeout > 0L, "handshake timeout is %s, but must be positive", timeout);
        this.handshakeTimeoutMillis = unit.toMillis(timeout);
        return this.thisT();
    }

    @Override
    public final T setBinaryLog(BinaryLog binaryLog) {
        this.binlog = binaryLog;
        return this.thisT();
    }

    @VisibleForTesting
    protected T overrideCensusStatsModule(CensusStatsModule censusStats) {
        this.censusStatsOverride = censusStats;
        return this.thisT();
    }

    protected void setStatsEnabled(boolean value) {
        this.statsEnabled = value;
    }

    protected void setStatsRecordStartedRpcs(boolean value) {
        this.recordStartedRpcs = value;
    }

    protected void setStatsRecordFinishedRpcs(boolean value) {
        this.recordFinishedRpcs = value;
    }

    protected void setTracingEnabled(boolean value) {
        this.tracingEnabled = value;
    }

    @Override
    public Server build() {
        ServerImpl server = new ServerImpl(this, this.buildTransportServer(Collections.unmodifiableList(this.getTracerFactories())), Context.ROOT);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    @VisibleForTesting
    final List<ServerStreamTracer.Factory> getTracerFactories() {
        ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList<ServerStreamTracer.Factory>();
        if (this.statsEnabled) {
            CensusStatsModule censusStats = this.censusStatsOverride;
            if (censusStats == null) {
                censusStats = new CensusStatsModule(GrpcUtil.STOPWATCH_SUPPLIER, true);
            }
            tracerFactories.add(censusStats.getServerTracerFactory(this.recordStartedRpcs, this.recordFinishedRpcs));
        }
        if (this.tracingEnabled) {
            CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getPropagationComponent().getBinaryFormat());
            tracerFactories.add(censusTracing.getServerTracerFactory());
        }
        tracerFactories.addAll(this.streamTracerFactories);
        return tracerFactories;
    }

    @Internal
    protected abstract InternalServer buildTransportServer(List<ServerStreamTracer.Factory> var1);

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

