/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.stub;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.stub.CallStreamObserver;
import java.util.Iterator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
public final class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

