/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.trace.samplers;

import alluxio.shaded.client.io.opencensus.internal.Utils;
import alluxio.shaded.client.io.opencensus.trace.Sampler;
import alluxio.shaded.client.io.opencensus.trace.Span;
import alluxio.shaded.client.io.opencensus.trace.SpanContext;
import alluxio.shaded.client.io.opencensus.trace.SpanId;
import alluxio.shaded.client.io.opencensus.trace.TraceId;
import alluxio.shaded.client.io.opencensus.trace.samplers.AutoValue_ProbabilitySampler;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;
import java.util.List;

@Immutable
abstract class ProbabilitySampler
extends Sampler {
    ProbabilitySampler() {
    }

    abstract double getProbability();

    abstract long getIdUpperBound();

    static ProbabilitySampler create(double probability) {
        Utils.checkArgument(probability >= 0.0 && probability <= 1.0, "probability must be in range [0.0, 1.0]");
        long idUpperBound = probability == 0.0 ? Long.MIN_VALUE : (probability == 1.0 ? Long.MAX_VALUE : (long)(probability * 9.223372036854776E18));
        return new AutoValue_ProbabilitySampler(probability, idUpperBound);
    }

    @Override
    public final boolean shouldSample(@Nullable SpanContext parentContext, @Nullable Boolean hasRemoteParent, TraceId traceId, SpanId spanId, String name, @Nullable List<Span> parentLinks) {
        if (parentContext != null && parentContext.getTraceOptions().isSampled()) {
            return true;
        }
        if (parentLinks != null) {
            for (Span parentLink : parentLinks) {
                if (!parentLink.getContext().getTraceOptions().isSampled()) continue;
                return true;
            }
        }
        return Math.abs(traceId.getLowerLong()) < this.getIdUpperBound();
    }

    @Override
    public final String getDescription() {
        return String.format("ProbabilitySampler{%.6f}", this.getProbability());
    }
}

