/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.commons.lang.StringUtils;
import alluxio.wire.LogInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

@ThreadSafe
public final class LogUtils {
    private LogUtils() {
    }

    public static LogInfo setLogLevel(String logName, String level) throws IOException {
        LogInfo result = new LogInfo();
        if (StringUtils.isNotBlank(logName)) {
            result.setLogName(logName);
            Log log = LogFactory.getLog((String)logName);
            Logger logger = LoggerFactory.getLogger((String)logName);
            if (log instanceof Log4JLogger) {
                LogUtils.process(((Log4JLogger)log).getLogger(), level, result);
            } else if (log instanceof Jdk14Logger) {
                LogUtils.process(((Jdk14Logger)log).getLogger(), level, result);
            } else if (logger instanceof Log4jLoggerAdapter) {
                try {
                    Field field = Log4jLoggerAdapter.class.getDeclaredField("logger");
                    field.setAccessible(true);
                    org.apache.log4j.Logger log4jLogger = (org.apache.log4j.Logger)field.get(logger);
                    LogUtils.process(log4jLogger, level, result);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    result.setMessage(e.getMessage());
                }
            } else {
                result.setMessage("Sorry, " + log.getClass() + " not supported.");
            }
        } else {
            result.setMessage("Please specify a correct logName.");
        }
        return result;
    }

    private static void process(org.apache.log4j.Logger log, String level, LogInfo result) throws IOException {
        if (log == null) {
            result.setMessage("log is null.");
            return;
        }
        if (level != null) {
            if (!level.equals(org.apache.log4j.Level.toLevel((String)level).toString())) {
                result.setMessage("Bad level : " + level);
            } else {
                log.setLevel(org.apache.log4j.Level.toLevel((String)level));
                result.setMessage("Setting Level to " + level);
            }
        }
        org.apache.log4j.Level lev = null;
        for (org.apache.log4j.Logger category = log; category != null && (lev = category.getLevel()) == null; category = category.getParent()) {
        }
        if (lev != null) {
            result.setLevel(lev.toString());
        }
    }

    private static void process(java.util.logging.Logger log, String level, LogInfo result) throws IOException {
        Level lev;
        if (log == null) {
            result.setMessage("log is null.");
            return;
        }
        if (level != null) {
            log.setLevel(Level.parse(level));
            result.setMessage("Setting Level to " + level);
        }
        while ((lev = log.getLevel()) == null) {
            log = log.getParent();
        }
        result.setLevel(lev.toString());
    }

    public static void warnWithException(Logger logger, String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, args);
        } else {
            if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
                args[args.length - 1] = ((Throwable)args[args.length - 1]).getMessage();
            }
            logger.warn(message + ": {}", args);
        }
    }
}

