/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.AlluxioURI;
import alluxio.grpc.BackupPResponse;
import alluxio.shaded.client.com.google.common.base.Preconditions;

public class BackupResponse {
    private AlluxioURI mBackupUri;
    private String mHostname;
    private long mEntryCount;

    public BackupResponse(AlluxioURI backupUri, String hostname, long entryCount) {
        this.mBackupUri = Preconditions.checkNotNull(backupUri, "backupUri");
        this.mHostname = Preconditions.checkNotNull(hostname, "hostname");
        this.mEntryCount = entryCount;
    }

    public static BackupResponse fromProto(BackupPResponse pResp) {
        return new BackupResponse(new AlluxioURI(pResp.getBackupUri()), pResp.getHostname(), pResp.getEntryCount());
    }

    public BackupPResponse toProto() {
        return BackupPResponse.newBuilder().setBackupUri(this.mBackupUri.toString()).setHostname(this.mHostname).setEntryCount(this.mEntryCount).build();
    }

    public AlluxioURI getBackupUri() {
        return this.mBackupUri;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public long getEntryCount() {
        return this.mEntryCount;
    }
}

