/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForCachingDirectoryLister;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.weakref.jmx.Managed;

public class CachingDirectoryLister
implements DirectoryLister {
    private final Cache<Path, List<HiveFileInfo>> cache;
    private final Set<SchemaTableName> cachedTableNames;
    protected final DirectoryLister delegate;

    @Inject
    public CachingDirectoryLister(@ForCachingDirectoryLister DirectoryLister delegate, HiveClientConfig hiveClientConfig) {
        this(delegate, hiveClientConfig.getFileStatusCacheExpireAfterWrite(), hiveClientConfig.getFileStatusCacheMaxSize(), hiveClientConfig.getFileStatusCacheTables().stream().map(CachingDirectoryLister::parseTableName).collect(Collectors.toSet()));
    }

    public CachingDirectoryLister(DirectoryLister delegate, Duration expireAfterWrite, long maxSize, Set<SchemaTableName> tables) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = CacheBuilder.newBuilder().maximumWeight(maxSize).weigher((key, value) -> value.size()).expireAfterWrite(expireAfterWrite.toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        this.cachedTableNames = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tables, "cachedTableNames is null"));
    }

    private static SchemaTableName parseTableName(String tableName) {
        String[] parts = tableName.split("\\.");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid schemaTableName: %s", (Object)tableName);
        return new SchemaTableName(parts[0], parts[1]);
    }

    @Override
    public Iterator<HiveFileInfo> list(FileSystem fileSystem, Table table, Path path, NamenodeStats namenodeStats, HiveFileIterator.NestedDirectoryPolicy nestedDirectoryPolicy, PathFilter pathFilter) {
        SchemaTableName schemaTableName = new SchemaTableName(table.getDatabaseName(), table.getTableName());
        List files = (List)this.cache.getIfPresent((Object)path);
        if (files != null) {
            return files.iterator();
        }
        Iterator<HiveFileInfo> iterator = this.delegate.list(fileSystem, table, path, namenodeStats, nestedDirectoryPolicy, pathFilter);
        if (this.cachedTableNames.contains(schemaTableName)) {
            return this.cachingIterator(iterator, path);
        }
        return iterator;
    }

    private Iterator<HiveFileInfo> cachingIterator(final Iterator<HiveFileInfo> iterator, final Path path) {
        return new Iterator<HiveFileInfo>(){
            private final List<HiveFileInfo> files = new ArrayList<HiveFileInfo>();

            @Override
            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    CachingDirectoryLister.this.cache.put((Object)path, (Object)ImmutableList.copyOf(this.files));
                }
                return hasNext;
            }

            @Override
            public HiveFileInfo next() {
                HiveFileInfo next = (HiveFileInfo)iterator.next();
                this.files.add(next);
                return next;
            }
        };
    }

    @Managed
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Managed
    public Double getHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    @Managed
    public long getMissCount() {
        return this.cache.stats().missCount();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }
}

