/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.CachingInputStream;
import com.facebook.presto.hive.FileOpener;
import com.facebook.presto.hive.ForCachingFileOpener;
import com.facebook.presto.hive.HiveFileContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CachingFileOpener
implements FileOpener {
    private final CacheManager cacheManager;
    private final FileOpener fileOpener;

    @Inject
    public CachingFileOpener(CacheManager cacheManager, @ForCachingFileOpener FileOpener fileOpener) {
        this.cacheManager = Objects.requireNonNull(cacheManager, "Cache Manager is null");
        this.fileOpener = Objects.requireNonNull(fileOpener, "File opener is null");
    }

    @Override
    public FSDataInputStream open(FileSystem fileSystem, Path path, HiveFileContext hiveFileContext) throws IOException {
        Preconditions.checkArgument((boolean)(fileSystem instanceof CachingFileSystem), (Object)"fileSystem should be of CachingFileSystem type");
        CachingFileSystem cachingFileSystem = (CachingFileSystem)fileSystem;
        FSDataInputStream inputStream = this.fileOpener.open(cachingFileSystem.getDataTier(), path, hiveFileContext);
        if (hiveFileContext.isCacheable()) {
            return new CachingInputStream(inputStream, this.cacheManager, path, cachingFileSystem.isCacheValidationEnabled());
        }
        return inputStream;
    }
}

