/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;

public class HiveCoercionPolicy
implements CoercionPolicy {
    private final TypeManager typeManager;

    @Inject
    public HiveCoercionPolicy(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public boolean canCoerce(HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = this.typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = this.typeManager.getType(toHiveType.getTypeSignature());
        if (fromType instanceof VarcharType) {
            return toHiveType.equals((Object)HiveType.HIVE_BYTE) || toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        if (toType instanceof VarcharType) {
            return fromHiveType.equals((Object)HiveType.HIVE_BYTE) || fromHiveType.equals((Object)HiveType.HIVE_SHORT) || fromHiveType.equals((Object)HiveType.HIVE_INT) || fromHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_BYTE)) {
            return toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_SHORT)) {
            return toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_INT)) {
            return toHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_FLOAT)) {
            return toHiveType.equals((Object)HiveType.HIVE_DOUBLE);
        }
        return this.canCoerceForList(fromHiveType, toHiveType) || this.canCoerceForMap(fromHiveType, toHiveType) || this.canCoerceForStruct(fromHiveType, toHiveType);
    }

    private boolean canCoerceForMap(HiveType fromHiveType, HiveType toHiveType) {
        if (!fromHiveType.getCategory().equals((Object)ObjectInspector.Category.MAP) || !toHiveType.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return false;
        }
        HiveType fromKeyType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType fromValueType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        HiveType toKeyType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType toValueType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        return !(!fromKeyType.equals((Object)toKeyType) && !this.canCoerce(fromKeyType, toKeyType) || !fromValueType.equals((Object)toValueType) && !this.canCoerce(fromValueType, toValueType));
    }

    private boolean canCoerceForList(HiveType fromHiveType, HiveType toHiveType) {
        HiveType toElementType;
        if (!fromHiveType.getCategory().equals((Object)ObjectInspector.Category.LIST) || !toHiveType.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return false;
        }
        HiveType fromElementType = HiveType.valueOf((String)((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
        return fromElementType.equals((Object)(toElementType = HiveType.valueOf((String)((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName()))) || this.canCoerce(fromElementType, toElementType);
    }

    private boolean canCoerceForStruct(HiveType fromHiveType, HiveType toHiveType) {
        if (!fromHiveType.getCategory().equals((Object)ObjectInspector.Category.STRUCT) || !toHiveType.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return false;
        }
        ArrayList fromFieldNames = ((StructTypeInfo)fromHiveType.getTypeInfo()).getAllStructFieldNames();
        ArrayList toFieldNames = ((StructTypeInfo)toHiveType.getTypeInfo()).getAllStructFieldNames();
        List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
        List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
        for (int i = 0; i < Math.min(fromFieldTypes.size(), toFieldTypes.size()); ++i) {
            if (!((String)fromFieldNames.get(i)).equals(toFieldNames.get(i))) {
                return false;
            }
            if (fromFieldTypes.get(i).equals((Object)toFieldTypes.get(i)) || this.canCoerce(fromFieldTypes.get(i), toFieldTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

