/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveWritableTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<HiveColumnHandle> inputColumns;
    private final String filePrefix;
    private HivePageSinkMetadata pageSinkMetadata;
    private final LocationHandle locationHandle;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final HiveCompressionCodec compressionCodec;

    public HiveWritableTableHandle(String schemaName, String tableName, List<HiveColumnHandle> inputColumns, String filePrefix, HivePageSinkMetadata pageSinkMetadata, LocationHandle locationHandle, Optional<HiveBucketProperty> bucketProperty, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, HiveCompressionCodec compressionCodec) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.filePrefix = Objects.requireNonNull(filePrefix, "filePrefix is null");
        this.pageSinkMetadata = Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<HiveColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @JsonProperty
    public HivePageSinkMetadata getPageSinkMetadata() {
        return this.pageSinkMetadata;
    }

    @JsonProperty
    public LocationHandle getLocationHandle() {
        return this.locationHandle;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public HiveStorageFormat getTableStorageFormat() {
        return this.tableStorageFormat;
    }

    @JsonProperty
    public HiveStorageFormat getPartitionStorageFormat() {
        return this.partitionStorageFormat;
    }

    @JsonProperty
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

