/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.orc.OrcWriterOptions;
import io.airlift.units.DataSize;

public class OrcFileWriterConfig {
    private OrcWriterOptions options = new OrcWriterOptions();

    public OrcWriterOptions toOrcWriterOptions() {
        return this.options;
    }

    public DataSize getStripeMinSize() {
        return this.options.getStripeMinSize();
    }

    @Config(value="hive.orc.writer.stripe-min-size")
    public OrcFileWriterConfig setStripeMinSize(DataSize stripeMinSize) {
        this.options = this.options.withStripeMinSize(stripeMinSize);
        return this;
    }

    public DataSize getStripeMaxSize() {
        return this.options.getStripeMaxSize();
    }

    @Config(value="hive.orc.writer.stripe-max-size")
    public OrcFileWriterConfig setStripeMaxSize(DataSize stripeMaxSize) {
        this.options = this.options.withStripeMaxSize(stripeMaxSize);
        return this;
    }

    public int getStripeMaxRowCount() {
        return this.options.getStripeMaxRowCount();
    }

    @Config(value="hive.orc.writer.stripe-max-rows")
    public OrcFileWriterConfig setStripeMaxRowCount(int stripeMaxRowCount) {
        this.options = this.options.withStripeMaxRowCount(stripeMaxRowCount);
        return this;
    }

    public int getRowGroupMaxRowCount() {
        return this.options.getRowGroupMaxRowCount();
    }

    @Config(value="hive.orc.writer.row-group-max-rows")
    public OrcFileWriterConfig setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        this.options = this.options.withRowGroupMaxRowCount(rowGroupMaxRowCount);
        return this;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.options.getDictionaryMaxMemory();
    }

    @Config(value="hive.orc.writer.dictionary-max-memory")
    public OrcFileWriterConfig setDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        this.options = this.options.withDictionaryMaxMemory(dictionaryMaxMemory);
        return this;
    }

    public DataSize getStringStatisticsLimit() {
        return this.options.getMaxStringStatisticsLimit();
    }

    @Config(value="hive.orc.writer.string-statistics-limit")
    public OrcFileWriterConfig setStringStatisticsLimit(DataSize stringStatisticsLimit) {
        this.options = this.options.withMaxStringStatisticsLimit(stringStatisticsLimit);
        return this;
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.options.getMaxCompressionBufferSize();
    }

    @Config(value="hive.orc.writer.max-compression-buffer-size")
    public OrcFileWriterConfig setMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        this.options = this.options.withMaxCompressionBufferSize(maxCompressionBufferSize);
        return this;
    }
}

