/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.plugin.base.security.ForwardingConnectorAccessControl;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SystemTableAwareAccessControl
extends ForwardingConnectorAccessControl {
    private final ConnectorAccessControl delegate;

    public SystemTableAwareAccessControl(ConnectorAccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected ConnectorAccessControl delegate() {
        return this.delegate;
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate.checkCanCreateSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate.checkCanDropSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName, String newSchemaName) {
        this.delegate.checkCanRenameSchema(transactionHandle, identity, schemaName, newSchemaName);
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
        this.delegate.checkCanShowSchemas(transactionHandle, identity);
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> schemaNames) {
        return this.delegate.filterSchemas(transactionHandle, identity, schemaNames);
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanCreateTable(transactionHandle, identity, tableName);
    }

    public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanDropTable(transactionHandle, identity, tableName);
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        this.delegate.checkCanRenameTable(transactionHandle, identity, tableName, newTableName);
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate.checkCanShowTablesMetadata(transactionHandle, identity, schemaName);
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<SchemaTableName> tableNames) {
        return this.delegate.filterTables(transactionHandle, identity, tableNames);
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanAddColumn(transactionHandle, identity, tableName);
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanDropColumn(transactionHandle, identity, tableName);
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanRenameColumn(transactionHandle, identity, tableName);
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        Optional<SchemaTableName> sourceTableName = HiveMetadata.getSourceTableNameFromSystemTable(tableName);
        if (sourceTableName.isPresent()) {
            try {
                this.checkCanSelectFromColumns(transactionHandle, identity, sourceTableName.get(), columnNames);
                return;
            }
            catch (AccessDeniedException e) {
                AccessDeniedException.denySelectTable((String)tableName.toString());
            }
        }
        this.delegate.checkCanSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanInsertIntoTable(transactionHandle, identity, tableName);
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate.checkCanDeleteFromTable(transactionHandle, identity, tableName);
    }

    public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        this.delegate.checkCanCreateView(transactionHandle, identity, viewName);
    }

    public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        this.delegate.checkCanDropView(transactionHandle, identity, viewName);
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate.checkCanCreateViewWithSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String propertyName) {
        this.delegate.checkCanSetCatalogSessionProperty(transactionHandle, identity, propertyName);
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate.checkCanGrantTablePrivilege(transactionHandle, identity, privilege, tableName, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate.checkCanRevokeTablePrivilege(transactionHandle, identity, privilege, tableName, revokee, grantOptionFor);
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, Optional<PrestoPrincipal> grantor) {
        this.delegate.checkCanCreateRole(transactionHandle, identity, role, grantor);
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role) {
        this.delegate.checkCanDropRole(transactionHandle, identity, role);
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate.checkCanGrantRoles(transactionHandle, identity, roles, grantees, withAdminOption, grantor, catalogName);
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate.checkCanRevokeRoles(transactionHandle, identity, roles, grantees, adminOptionFor, grantor, catalogName);
    }

    public void checkCanSetRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, String catalogName) {
        this.delegate.checkCanSetRole(transactionHandle, identity, role, catalogName);
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate.checkCanShowRoles(transactionHandle, identity, catalogName);
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate.checkCanShowCurrentRoles(transactionHandle, identity, catalogName);
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate.checkCanShowRoleGrants(transactionHandle, identity, catalogName);
    }
}

