/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.$internal.com.google.common.base.Joiner;
import com.datastax.driver.$internal.com.google.common.base.Objects;
import com.datastax.driver.$internal.com.google.common.base.Optional;
import com.datastax.driver.$internal.com.google.common.collect.Lists;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.AbstractCreateStatement;
import com.datastax.driver.core.schemabuilder.ColumnType;
import com.datastax.driver.core.schemabuilder.NativeColumnType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.TableOptions;
import com.datastax.driver.core.schemabuilder.UDTType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Create
extends AbstractCreateStatement<Create> {
    private String tableName;
    private Map<String, ColumnType> partitionColumns = new LinkedHashMap<String, ColumnType>();
    private Map<String, ColumnType> clusteringColumns = new LinkedHashMap<String, ColumnType>();
    private Map<String, ColumnType> staticColumns = new LinkedHashMap<String, ColumnType>();

    Create(String keyspaceName, String tableName) {
        Create.validateNotEmpty(keyspaceName, "Keyspace name");
        Create.validateNotEmpty(tableName, "Table name");
        Create.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        Create.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        this.keyspaceName = Optional.fromNullable(keyspaceName);
    }

    Create(String tableName) {
        Create.validateNotEmpty(tableName, "Table name");
        Create.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
    }

    public Create addPartitionKey(String columnName, DataType dataType) {
        Create.validateNotEmpty(columnName, "Partition key name");
        Create.validateNotNull(dataType, "Partition key type");
        Create.validateNotKeyWord(columnName, String.format("The partition key name '%s' is not allowed because it is a reserved keyword", columnName));
        this.partitionColumns.put(columnName, new NativeColumnType(dataType));
        return this;
    }

    public Create addUDTPartitionKey(String columnName, UDTType udtType) {
        Create.validateNotEmpty(columnName, "Clustering key name");
        Create.validateNotNull(udtType, "UDT partition key type");
        Create.validateNotKeyWord(columnName, String.format("The partition key name '%s' is not allowed because it is a reserved keyword", columnName));
        this.partitionColumns.put(columnName, udtType);
        return this;
    }

    public Create addClusteringColumn(String columnName, DataType dataType) {
        Create.validateNotEmpty(columnName, "Clustering column name");
        Create.validateNotNull(dataType, "Clustering column type");
        Create.validateNotKeyWord(columnName, String.format("The clustering column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.clusteringColumns.put(columnName, new NativeColumnType(dataType));
        return this;
    }

    public Create addUDTClusteringColumn(String columnName, UDTType udtType) {
        Create.validateNotEmpty(columnName, "Clustering column name");
        Create.validateNotNull(udtType, "UDT clustering column type");
        Create.validateNotKeyWord(columnName, String.format("The clustering column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.clusteringColumns.put(columnName, udtType);
        return this;
    }

    public Create addStaticColumn(String columnName, DataType dataType) {
        Create.validateNotEmpty(columnName, "Column name");
        Create.validateNotNull(dataType, "Column type");
        Create.validateNotKeyWord(columnName, String.format("The static column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.staticColumns.put(columnName, new NativeColumnType(dataType));
        return this;
    }

    public Create addUDTStaticColumn(String columnName, UDTType udtType) {
        Create.validateNotEmpty(this.tableName, "Column name");
        Create.validateNotNull(udtType, "Column UDT type");
        Create.validateNotKeyWord(columnName, String.format("The static column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.staticColumns.put(columnName, udtType);
        return this;
    }

    public Options withOptions() {
        return new Options(this);
    }

    @Override
    public String buildInternal() {
        if (this.partitionColumns.size() < 1) {
            throw new IllegalStateException(String.format("There should be at least one partition key defined for the table '%s'", this.tableName));
        }
        this.validateColumnsDeclaration();
        StringBuilder createStatement = new StringBuilder("\n\t").append("CREATE TABLE");
        if (this.ifNotExists) {
            createStatement.append(" IF NOT EXISTS");
        }
        createStatement.append(" ");
        if (this.keyspaceName.isPresent()) {
            createStatement.append((String)this.keyspaceName.get()).append(".");
        }
        createStatement.append(this.tableName);
        ArrayList<String> allColumns = new ArrayList<String>();
        ArrayList<String> partitionKeyColumns = new ArrayList<String>();
        ArrayList<String> clusteringKeyColumns = new ArrayList<String>();
        for (Map.Entry<String, ColumnType> entry : this.partitionColumns.entrySet()) {
            allColumns.add(entry.getKey() + " " + entry.getValue().asCQLString());
            partitionKeyColumns.add(entry.getKey());
        }
        for (Map.Entry<String, ColumnType> entry : this.clusteringColumns.entrySet()) {
            allColumns.add(entry.getKey() + " " + entry.getValue().asCQLString());
            clusteringKeyColumns.add(entry.getKey());
        }
        for (Map.Entry<String, ColumnType> entry : this.staticColumns.entrySet()) {
            allColumns.add(entry.getKey() + " " + entry.getValue().asCQLString() + " static");
        }
        for (Map.Entry<String, ColumnType> entry : this.simpleColumns.entrySet()) {
            allColumns.add(this.buildColumnType(entry));
        }
        String partitionKeyPart = partitionKeyColumns.size() == 1 ? (String)partitionKeyColumns.get(0) : "(" + Joiner.on(", ").join(partitionKeyColumns) + ")";
        String string = clusteringKeyColumns.size() == 0 ? partitionKeyPart : partitionKeyPart + ", " + Joiner.on(", ").join(clusteringKeyColumns);
        createStatement.append("(").append("\n\t\t");
        createStatement.append(Joiner.on(",\n\t\t").join(allColumns));
        createStatement.append(",\n\t\t").append("PRIMARY KEY");
        createStatement.append("(").append(string).append(")");
        createStatement.append(")");
        return createStatement.toString();
    }

    private void validateColumnsDeclaration() {
        Collection<String> partitionAndClusteringColumns = this.intersection(this.partitionColumns.keySet(), this.clusteringColumns.keySet());
        Collection<String> partitionAndSimpleColumns = this.intersection(this.partitionColumns.keySet(), this.simpleColumns.keySet());
        Collection<String> clusteringAndSimpleColumns = this.intersection(this.clusteringColumns.keySet(), this.simpleColumns.keySet());
        Collection<String> partitionAndStaticColumns = this.intersection(this.partitionColumns.keySet(), this.staticColumns.keySet());
        Collection<String> clusteringAndStaticColumns = this.intersection(this.clusteringColumns.keySet(), this.staticColumns.keySet());
        Collection<String> simpleAndStaticColumns = this.intersection(this.simpleColumns.keySet(), this.staticColumns.keySet());
        if (!partitionAndClusteringColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and clustering keys at the same time", partitionAndClusteringColumns));
        }
        if (!partitionAndSimpleColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and simple columns at the same time", partitionAndSimpleColumns));
        }
        if (!clusteringAndSimpleColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as clustering keys and simple columns at the same time", clusteringAndSimpleColumns));
        }
        if (!partitionAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and static columns at the same time", partitionAndStaticColumns));
        }
        if (!clusteringAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as clustering keys and static columns at the same time", clusteringAndStaticColumns));
        }
        if (!simpleAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as simple columns and static columns at the same time", simpleAndStaticColumns));
        }
        if (!this.staticColumns.isEmpty() && this.clusteringColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The table '%s' cannot declare static columns '%s' without clustering columns", this.tableName, this.staticColumns.keySet()));
        }
    }

    private <T> Collection<T> intersection(Collection<T> col1, Collection<T> col2) {
        HashSet<T> set = new HashSet<T>();
        for (T t : col1) {
            if (!col2.contains(t)) continue;
            set.add(t);
        }
        return set;
    }

    public static class Options
    extends TableOptions<Options> {
        private final Create create;
        private List<ClusteringOrder> clusteringOrderKeys = Lists.newArrayList();
        private boolean compactStorage;

        private Options(Create create) {
            super(create.asStatementStart());
            this.create = create;
        }

        public Options clusteringOrder(String columnName, SchemaBuilder.Direction direction) {
            if (!this.create.clusteringColumns.containsKey(columnName)) {
                throw new IllegalArgumentException(String.format("Clustering key '%s' is unknown. Did you forget to declare it first?", columnName));
            }
            this.clusteringOrderKeys.add(new ClusteringOrder(columnName, direction));
            return this;
        }

        public Options compactStorage() {
            this.compactStorage = true;
            return this;
        }

        @Override
        protected void addSpecificOptions(List<String> options) {
            if (!this.clusteringOrderKeys.isEmpty()) {
                options.add("CLUSTERING ORDER BY(" + Joiner.on(", ").join(this.clusteringOrderKeys) + ")");
            }
            if (this.compactStorage) {
                if (!this.create.staticColumns.isEmpty()) {
                    throw new IllegalStateException(String.format("Cannot create table '%s' with compact storage and static columns '%s'", this.create.tableName, this.create.staticColumns.keySet()));
                }
                options.add("COMPACT STORAGE");
            }
        }

        private static class ClusteringOrder {
            private final String clusteringColumnName;
            private final SchemaBuilder.Direction direction;

            ClusteringOrder(String clusteringColumnName, SchemaBuilder.Direction direction) {
                SchemaStatement.validateNotEmpty(clusteringColumnName, "Column name for clustering order");
                this.clusteringColumnName = clusteringColumnName;
                this.direction = direction;
            }

            public String getClusteringColumnName() {
                return this.clusteringColumnName;
            }

            public String toStatement() {
                return this.clusteringColumnName + " " + this.direction.name();
            }

            public String toString() {
                return this.toStatement();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o instanceof ClusteringOrder) {
                    ClusteringOrder that = (ClusteringOrder)o;
                    return Objects.equal(this.clusteringColumnName, that.clusteringColumnName) && Objects.equal((Object)this.direction, (Object)that.direction);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hashCode(new Object[]{this.clusteringColumnName, this.direction});
            }
        }
    }
}

