/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.IntArrayBlock;
import com.facebook.presto.spi.block.LongArrayBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.block.ShortArrayBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongDirectBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDirectBatchStreamReader.class).instanceSize();
    private final Type type;
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private short[] shortNonNullValueTemp = new short[0];
    private int[] intNonNullValueTemp = new int[0];
    private long[] longNonNullValueTemp = new long[0];
    private LocalMemoryContext systemMemoryContext;

    public LongDirectBatchStreamReader(Type type, StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, t -> t instanceof BigintType || t instanceof IntegerType || t instanceof SmallintType || t instanceof DateType);
        this.type = type;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        if (this.type instanceof BigintType) {
            long[] values = new long[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new LongArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        if (this.type instanceof IntegerType || this.type instanceof DateType) {
            int[] values = new int[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new IntArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        if (this.type instanceof SmallintType) {
            short[] values = new short[this.nextBatchSize];
            this.dataStream.next(values, this.nextBatchSize);
            return new ShortArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        if (this.type instanceof BigintType) {
            return this.longReadNullBlock(isNull, nonNullCount);
        }
        if (this.type instanceof IntegerType || this.type instanceof DateType) {
            return this.intReadNullBlock(isNull, nonNullCount);
        }
        if (this.type instanceof SmallintType) {
            return this.shortReadNullBlock(isNull, nonNullCount);
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private Block longReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.longNonNullValueTemp.length < minNonNullValueSize) {
            this.longNonNullValueTemp = new long[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((long[])this.longNonNullValueTemp));
        }
        this.dataStream.next(this.longNonNullValueTemp, nonNullCount);
        long[] result = ReaderUtils.unpackLongNulls(this.longNonNullValueTemp, isNull);
        return new LongArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block intReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.intNonNullValueTemp.length < minNonNullValueSize) {
            this.intNonNullValueTemp = new int[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((int[])this.intNonNullValueTemp));
        }
        this.dataStream.next(this.intNonNullValueTemp, nonNullCount);
        int[] result = ReaderUtils.unpackIntNulls(this.intNonNullValueTemp, isNull);
        return new IntArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block shortReadNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.dataStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.shortNonNullValueTemp.length < minNonNullValueSize) {
            this.shortNonNullValueTemp = new short[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((short[])this.shortNonNullValueTemp));
        }
        this.dataStream.next(this.shortNonNullValueTemp, nonNullCount);
        short[] result = ReaderUtils.unpackShortNulls(this.shortNonNullValueTemp, isNull);
        return new ShortArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.shortNonNullValueTemp = null;
        this.intNonNullValueTemp = null;
        this.longNonNullValueTemp = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

