/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import io.airlift.units.Duration;
import java.util.Objects;

public class RetriesFailedException
extends Exception {
    private final int invocationAttempts;
    private final int failedConnections;
    private final Duration retryTime;
    private final int overloadedRejects;

    public RetriesFailedException(String reason, int invocationAttempts, Duration retryTime, int failedConnections, int overloadedRejects) {
        super(String.format("%s (invocationAttempts: %s, duration: %s, failedConnections: %s, overloadedRejects: %s)", reason, invocationAttempts, retryTime, failedConnections, overloadedRejects));
        this.invocationAttempts = invocationAttempts;
        this.failedConnections = failedConnections;
        this.retryTime = Objects.requireNonNull(retryTime, "retryTime is null");
        this.overloadedRejects = overloadedRejects;
    }

    public int getInvocationAttempts() {
        return this.invocationAttempts;
    }

    public int getFailedConnections() {
        return this.failedConnections;
    }

    public Duration getRetryTime() {
        return this.retryTime;
    }

    public int getOverloadedRejects() {
        return this.overloadedRejects;
    }
}

