/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class GlueHiveMetastoreConfig {
    private Optional<String> glueRegion = Optional.empty();
    private boolean pinGlueClientToCurrentRegion;
    private int maxGlueConnections = 5;
    private Optional<String> defaultWarehouseDir = Optional.empty();
    private Optional<String> catalogId = Optional.empty();
    private int partitionSegments = 5;
    private int getPartitionThreads = 20;

    public Optional<String> getGlueRegion() {
        return this.glueRegion;
    }

    @Config(value="hive.metastore.glue.region")
    @ConfigDescription(value="AWS Region for Glue Data Catalog")
    public GlueHiveMetastoreConfig setGlueRegion(String region) {
        this.glueRegion = Optional.ofNullable(region);
        return this;
    }

    public boolean getPinGlueClientToCurrentRegion() {
        return this.pinGlueClientToCurrentRegion;
    }

    @Config(value="hive.metastore.glue.pin-client-to-current-region")
    @ConfigDescription(value="Should the Glue client be pinned to the current EC2 region")
    public GlueHiveMetastoreConfig setPinGlueClientToCurrentRegion(boolean pinGlueClientToCurrentRegion) {
        this.pinGlueClientToCurrentRegion = pinGlueClientToCurrentRegion;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxGlueConnections() {
        return this.maxGlueConnections;
    }

    @Config(value="hive.metastore.glue.max-connections")
    @ConfigDescription(value="Max number of concurrent connections to Glue")
    public GlueHiveMetastoreConfig setMaxGlueConnections(int maxGlueConnections) {
        this.maxGlueConnections = maxGlueConnections;
        return this;
    }

    public Optional<String> getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="hive.metastore.glue.default-warehouse-dir")
    @ConfigDescription(value="Hive Glue metastore default warehouse directory")
    public GlueHiveMetastoreConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = Optional.ofNullable(defaultWarehouseDir);
        return this;
    }

    public Optional<String> getCatalogId() {
        return this.catalogId;
    }

    @Config(value="hive.metastore.glue.catalogid")
    @ConfigDescription(value="Hive Glue metastore catalog id")
    public GlueHiveMetastoreConfig setCatalogId(String catalogId) {
        this.catalogId = Optional.ofNullable(catalogId);
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    public @Min(value=1L) @Max(value=10L) int getPartitionSegments() {
        return this.partitionSegments;
    }

    @Config(value="hive.metastore.glue.partitions-segments")
    @ConfigDescription(value="Number of segments for partitioned Glue tables")
    public GlueHiveMetastoreConfig setPartitionSegments(int partitionSegments) {
        this.partitionSegments = partitionSegments;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getGetPartitionThreads() {
        return this.getPartitionThreads;
    }

    @Config(value="hive.metastore.glue.get-partition-threads")
    @ConfigDescription(value="Number of threads for parallel partition fetches from Glue")
    public GlueHiveMetastoreConfig setGetPartitionThreads(int getPartitionThreads) {
        this.getPartitionThreads = getPartitionThreads;
        return this;
    }
}

