/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.Transport;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import org.apache.thrift.transport.TTransportException;

public class HiveMetastoreClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostAndPort> socksProxy;
    private final int timeoutMillis;
    private final HiveMetastoreAuthentication metastoreAuthentication;

    public HiveMetastoreClientFactory(Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, Duration timeout, HiveMetastoreAuthentication metastoreAuthentication) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
        this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
        this.timeoutMillis = Math.toIntExact(timeout.toMillis());
        this.metastoreAuthentication = Objects.requireNonNull(metastoreAuthentication, "metastoreAuthentication is null");
    }

    @Inject
    public HiveMetastoreClientFactory(MetastoreClientConfig metastoreClientConfig, HiveMetastoreAuthentication metastoreAuthentication) {
        this(Optional.empty(), Optional.ofNullable(metastoreClientConfig.getMetastoreSocksProxy()), metastoreClientConfig.getMetastoreTimeout(), metastoreAuthentication);
    }

    public HiveMetastoreClient create(HostAndPort address) throws TTransportException {
        return new ThriftHiveMetastoreClient(Transport.create(address, this.sslContext, this.socksProxy, this.timeoutMillis, this.metastoreAuthentication));
    }
}

