/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.shaded.com.google.common.base.Functions;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Splitter;
import org.apache.kudu.shaded.com.google.common.collect.Iterables;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.shaded.com.google.common.net.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NetUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtil.class);

    public static String hostsAndPortsToString(List<org.apache.kudu.client.HostAndPort> hostsAndPorts) {
        return Joiner.on(",").join(Lists.transform(hostsAndPorts, Functions.toStringFunction()));
    }

    public static org.apache.kudu.client.HostAndPort parseString(String addrString, int defaultPort) {
        HostAndPort hostAndPort = addrString.indexOf(58) == -1 ? HostAndPort.fromParts(addrString, defaultPort) : HostAndPort.fromString(addrString);
        return new org.apache.kudu.client.HostAndPort(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static List<org.apache.kudu.client.HostAndPort> parseStrings(String commaSepAddrs, int defaultPort) {
        Iterable<String> addrStrings = Splitter.on(',').trimResults().split(commaSepAddrs);
        ArrayList<org.apache.kudu.client.HostAndPort> hostsAndPorts = Lists.newArrayListWithCapacity(Iterables.size(addrStrings));
        for (String addrString : addrStrings) {
            org.apache.kudu.client.HostAndPort hostAndPort = NetUtil.parseString(addrString, defaultPort);
            hostsAndPorts.add(hostAndPort);
        }
        return hostsAndPorts;
    }

    public static InetAddress getInetAddress(String host) {
        long start = System.nanoTime();
        try {
            InetAddress ip = InetAddress.getByName(host);
            long latency = System.nanoTime() - start;
            if (latency > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `{}' to {} in {}ns", host, ip, latency);
            } else if (latency >= 3000000L) {
                LOG.warn("Slow DNS lookup! Resolved IP of `{}' to {} in {}ns", host, ip, latency);
            }
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve the IP of `{}' in {}ns", (Object)host, (Object)(System.nanoTime() - start));
            return null;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return local;
    }
}

