/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.zookeeper.KeeperException;

public class ZookeeperLockChecker
implements TabletLocatorImpl.TabletServerLockChecker {
    private final ZooCache zc;
    private final String root;

    ZookeeperLockChecker(Instance instance) {
        this(instance, new ZooCacheFactory());
    }

    ZookeeperLockChecker(Instance instance, ZooCacheFactory zcf) {
        this.zc = zcf.getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        this.root = ZooUtil.getRoot(instance) + "/tservers";
    }

    @Override
    public boolean isLockHeld(String tserver, String session) {
        try {
            return ZooLock.getSessionId((ZooCache)this.zc, (String)(this.root + "/" + tserver)) == Long.parseLong(session, 16);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateCache(String tserver) {
        this.zc.clear(this.root + "/" + tserver);
    }
}

